package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEventsEndpointDetails(
    arn: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    endpointId: Optional[NonEmptyString] = Optional.Absent,
    endpointUrl: Optional[NonEmptyString] = Optional.Absent,
    eventBuses: Optional[
      Iterable[zio.aws.securityhub.model.AwsEventsEndpointEventBusesDetails]
    ] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    replicationConfig: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointReplicationConfigDetails
    ] = Optional.Absent,
    roleArn: Optional[NonEmptyString] = Optional.Absent,
    routingConfig: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigDetails
    ] = Optional.Absent,
    state: Optional[NonEmptyString] = Optional.Absent,
    stateReason: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointDetails = {
    import AwsEventsEndpointDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointDetails
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        endpointId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.endpointId)
      .optionallyWith(
        endpointUrl.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.endpointUrl)
      .optionallyWith(
        eventBuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventBuses)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(replicationConfig.map(value => value.buildAwsValue()))(
        _.replicationConfig
      )
      .optionallyWith(
        roleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(routingConfig.map(value => value.buildAwsValue()))(
        _.routingConfig
      )
      .optionallyWith(
        state.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(
        stateReason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.stateReason)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEventsEndpointDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEventsEndpointDetails.wrap(buildAwsValue())
}
object AwsEventsEndpointDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEventsEndpointDetails =
      zio.aws.securityhub.model.AwsEventsEndpointDetails(
        arn.map(value => value),
        description.map(value => value),
        endpointId.map(value => value),
        endpointUrl.map(value => value),
        eventBuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        replicationConfig.map(value => value.asEditable),
        roleArn.map(value => value),
        routingConfig.map(value => value.asEditable),
        state.map(value => value),
        stateReason.map(value => value)
      )
    def arn: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def endpointId: Optional[NonEmptyString]
    def endpointUrl: Optional[NonEmptyString]
    def eventBuses: Optional[List[
      zio.aws.securityhub.model.AwsEventsEndpointEventBusesDetails.ReadOnly
    ]]
    def name: Optional[NonEmptyString]
    def replicationConfig: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointReplicationConfigDetails.ReadOnly
    ]
    def roleArn: Optional[NonEmptyString]
    def routingConfig: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigDetails.ReadOnly
    ]
    def state: Optional[NonEmptyString]
    def stateReason: Optional[NonEmptyString]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getEndpointId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("endpointId", endpointId)
    def getEndpointUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("endpointUrl", endpointUrl)
    def getEventBuses: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEventsEndpointEventBusesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("eventBuses", eventBuses)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getReplicationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEventsEndpointReplicationConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("replicationConfig", replicationConfig)
    def getRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getRoutingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("routingConfig", routingConfig)
    def getState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("stateReason", stateReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointDetails
  ) extends zio.aws.securityhub.model.AwsEventsEndpointDetails.ReadOnly {
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpointId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpointUrl: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointUrl())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val eventBuses: Optional[List[
      zio.aws.securityhub.model.AwsEventsEndpointEventBusesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.eventBuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEventsEndpointEventBusesDetails
            .wrap(item)
        }.toList
      )
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val replicationConfig: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointReplicationConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsEventsEndpointReplicationConfigDetails
          .wrap(value)
      )
    override val roleArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val routingConfig: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.routingConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigDetails
          .wrap(value)
      )
    override val state: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val stateReason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.stateReason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointDetails
  ): zio.aws.securityhub.model.AwsEventsEndpointDetails.ReadOnly = new Wrapper(
    impl
  )
}
