package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskVolumeDetails(
    name: Optional[NonEmptyString] = Optional.Absent,
    host: Optional[zio.aws.securityhub.model.AwsEcsTaskVolumeHostDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeDetails = {
    import AwsEcsTaskVolumeDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeDetails
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(host.map(value => value.buildAwsValue()))(_.host)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEcsTaskVolumeDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskVolumeDetails.wrap(buildAwsValue())
}
object AwsEcsTaskVolumeDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEcsTaskVolumeDetails =
      zio.aws.securityhub.model.AwsEcsTaskVolumeDetails(
        name.map(value => value),
        host.map(value => value.asEditable)
      )
    def name: Optional[NonEmptyString]
    def host: Optional[
      zio.aws.securityhub.model.AwsEcsTaskVolumeHostDetails.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getHost: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskVolumeHostDetails.ReadOnly
    ] = AwsError.unwrapOptionField("host", host)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskVolumeDetails.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val host: Optional[
      zio.aws.securityhub.model.AwsEcsTaskVolumeHostDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.host())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskVolumeHostDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeDetails
  ): zio.aws.securityhub.model.AwsEcsTaskVolumeDetails.ReadOnly = new Wrapper(
    impl
  )
}
