package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails(
    add: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    drop: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails
      .builder()
      .optionallyWith(
        add.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.add)
      .optionallyWith(
        drop.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.drop)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails(
          add.map(value => value),
          drop.map(value => value)
        )
    def add: Optional[List[NonEmptyString]]
    def drop: Optional[List[NonEmptyString]]
    def getAdd: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("add", add)
    def getDrop: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("drop", drop)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.ReadOnly {
    override val add: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.add())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val drop: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.drop())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails.ReadOnly =
    new Wrapper(impl)
}
