package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2VpcPeeringConnectionVpcInfoDetails(
    cidrBlock: Optional[NonEmptyString] = Optional.Absent,
    cidrBlockSet: Optional[
      Iterable[zio.aws.securityhub.model.VpcInfoCidrBlockSetDetails]
    ] = Optional.Absent,
    ipv6CidrBlockSet: Optional[
      Iterable[zio.aws.securityhub.model.VpcInfoIpv6CidrBlockSetDetails]
    ] = Optional.Absent,
    ownerId: Optional[NonEmptyString] = Optional.Absent,
    peeringOptions: Optional[
      zio.aws.securityhub.model.VpcInfoPeeringOptionsDetails
    ] = Optional.Absent,
    region: Optional[NonEmptyString] = Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails = {
    import AwsEc2VpcPeeringConnectionVpcInfoDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails
      .builder()
      .optionallyWith(
        cidrBlock.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cidrBlock)
      .optionallyWith(
        cidrBlockSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cidrBlockSet)
      .optionallyWith(
        ipv6CidrBlockSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6CidrBlockSet)
      .optionallyWith(
        ownerId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(peeringOptions.map(value => value.buildAwsValue()))(
        _.peeringOptions
      )
      .optionallyWith(
        region.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails
      .wrap(buildAwsValue())
}
object AwsEc2VpcPeeringConnectionVpcInfoDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails =
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails(
        cidrBlock.map(value => value),
        cidrBlockSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6CidrBlockSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerId.map(value => value),
        peeringOptions.map(value => value.asEditable),
        region.map(value => value),
        vpcId.map(value => value)
      )
    def cidrBlock: Optional[NonEmptyString]
    def cidrBlockSet: Optional[
      List[zio.aws.securityhub.model.VpcInfoCidrBlockSetDetails.ReadOnly]
    ]
    def ipv6CidrBlockSet: Optional[
      List[zio.aws.securityhub.model.VpcInfoIpv6CidrBlockSetDetails.ReadOnly]
    ]
    def ownerId: Optional[NonEmptyString]
    def peeringOptions: Optional[
      zio.aws.securityhub.model.VpcInfoPeeringOptionsDetails.ReadOnly
    ]
    def region: Optional[NonEmptyString]
    def vpcId: Optional[NonEmptyString]
    def getCidrBlock: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getCidrBlockSet: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.VpcInfoCidrBlockSetDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("cidrBlockSet", cidrBlockSet)
    def getIpv6CidrBlockSet: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.VpcInfoIpv6CidrBlockSetDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6CidrBlockSet", ipv6CidrBlockSet)
    def getOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getPeeringOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.VpcInfoPeeringOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("peeringOptions", peeringOptions)
    def getRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("region", region)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails
  ) extends zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails.ReadOnly {
    override val cidrBlock: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlock())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val cidrBlockSet: Optional[
      List[zio.aws.securityhub.model.VpcInfoCidrBlockSetDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlockSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.VpcInfoCidrBlockSetDetails.wrap(item)
        }.toList
      )
    override val ipv6CidrBlockSet: Optional[
      List[zio.aws.securityhub.model.VpcInfoIpv6CidrBlockSetDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6CidrBlockSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.VpcInfoIpv6CidrBlockSetDetails.wrap(item)
        }.toList
      )
    override val ownerId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val peeringOptions: Optional[
      zio.aws.securityhub.model.VpcInfoPeeringOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.peeringOptions())
      .map(value =>
        zio.aws.securityhub.model.VpcInfoPeeringOptionsDetails.wrap(value)
      )
    override val region: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails
  ): zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionVpcInfoDetails.ReadOnly =
    new Wrapper(impl)
}
