package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataMonitoringDetails(
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails = {
    import AwsEc2LaunchTemplateDataMonitoringDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataMonitoringDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataMonitoringDetails(enabled.map(value => value))
    def enabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMonitoringDetails.ReadOnly =
    new Wrapper(impl)
}
