package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataMaintenanceOptionsDetails(
    autoRecovery: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails = {
    import AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails
      .builder()
      .optionallyWith(
        autoRecovery.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.autoRecovery)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataMaintenanceOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataMaintenanceOptionsDetails(
          autoRecovery.map(value => value)
        )
    def autoRecovery: Optional[NonEmptyString]
    def getAutoRecovery: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("autoRecovery", autoRecovery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.ReadOnly {
    override val autoRecovery: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.autoRecovery())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
