package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails(
    blockDurationMinutes: Optional[Integer] = Optional.Absent,
    instanceInterruptionBehavior: Optional[NonEmptyString] = Optional.Absent,
    maxPrice: Optional[NonEmptyString] = Optional.Absent,
    spotInstanceType: Optional[NonEmptyString] = Optional.Absent,
    validUntil: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails = {
    import AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails
      .builder()
      .optionallyWith(
        blockDurationMinutes.map(value => value: java.lang.Integer)
      )(_.blockDurationMinutes)
      .optionallyWith(
        instanceInterruptionBehavior.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceInterruptionBehavior)
      .optionallyWith(
        maxPrice.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.maxPrice)
      .optionallyWith(
        spotInstanceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.spotInstanceType)
      .optionallyWith(
        validUntil.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.validUntil)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails(
          blockDurationMinutes.map(value => value),
          instanceInterruptionBehavior.map(value => value),
          maxPrice.map(value => value),
          spotInstanceType.map(value => value),
          validUntil.map(value => value)
        )
    def blockDurationMinutes: Optional[Integer]
    def instanceInterruptionBehavior: Optional[NonEmptyString]
    def maxPrice: Optional[NonEmptyString]
    def spotInstanceType: Optional[NonEmptyString]
    def validUntil: Optional[NonEmptyString]
    def getBlockDurationMinutes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("blockDurationMinutes", blockDurationMinutes)
    def getInstanceInterruptionBehavior: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "instanceInterruptionBehavior",
        instanceInterruptionBehavior
      )
    def getMaxPrice: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("maxPrice", maxPrice)
    def getSpotInstanceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("spotInstanceType", spotInstanceType)
    def getValidUntil: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("validUntil", validUntil)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.ReadOnly {
    override val blockDurationMinutes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.blockDurationMinutes())
      .map(value => value: Integer)
    override val instanceInterruptionBehavior: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceInterruptionBehavior())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val maxPrice: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.maxPrice())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val spotInstanceType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotInstanceType())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val validUntil: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.validUntil())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
