package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails(
    count: Optional[Integer] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails = {
    import AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails
      .builder()
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails(
          count.map(value => value),
          `type`.map(value => value)
        )
    def count: Optional[Integer]
    def `type`: Optional[NonEmptyString]
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.ReadOnly {
    override val count: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Integer)
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.ReadOnly =
    new Wrapper(impl)
}
