package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataCpuOptionsDetails(
    coreCount: Optional[Integer] = Optional.Absent,
    threadsPerCore: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails = {
    import AwsEc2LaunchTemplateDataCpuOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails
      .builder()
      .optionallyWith(coreCount.map(value => value: java.lang.Integer))(
        _.coreCount
      )
      .optionallyWith(threadsPerCore.map(value => value: java.lang.Integer))(
        _.threadsPerCore
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataCpuOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails =
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails(
        coreCount.map(value => value),
        threadsPerCore.map(value => value)
      )
    def coreCount: Optional[Integer]
    def threadsPerCore: Optional[Integer]
    def getCoreCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("coreCount", coreCount)
    def getThreadsPerCore: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("threadsPerCore", threadsPerCore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails.ReadOnly {
    override val coreCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.coreCount())
      .map(value => value: Integer)
    override val threadsPerCore: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.threadsPerCore())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCpuOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
