package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsDmsReplicationTaskDetails(
    cdcStartPosition: Optional[NonEmptyString] = Optional.Absent,
    cdcStartTime: Optional[NonEmptyString] = Optional.Absent,
    cdcStopPosition: Optional[NonEmptyString] = Optional.Absent,
    migrationType: Optional[NonEmptyString] = Optional.Absent,
    id: Optional[NonEmptyString] = Optional.Absent,
    resourceIdentifier: Optional[NonEmptyString] = Optional.Absent,
    replicationInstanceArn: Optional[NonEmptyString] = Optional.Absent,
    replicationTaskIdentifier: Optional[NonEmptyString] = Optional.Absent,
    replicationTaskSettings: Optional[NonEmptyString] = Optional.Absent,
    sourceEndpointArn: Optional[NonEmptyString] = Optional.Absent,
    tableMappings: Optional[NonEmptyString] = Optional.Absent,
    targetEndpointArn: Optional[NonEmptyString] = Optional.Absent,
    taskData: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationTaskDetails = {
    import AwsDmsReplicationTaskDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationTaskDetails
      .builder()
      .optionallyWith(
        cdcStartPosition.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cdcStartPosition)
      .optionallyWith(
        cdcStartTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cdcStartTime)
      .optionallyWith(
        cdcStopPosition.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cdcStopPosition)
      .optionallyWith(
        migrationType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.migrationType)
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        resourceIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resourceIdentifier)
      .optionallyWith(
        replicationInstanceArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.replicationInstanceArn)
      .optionallyWith(
        replicationTaskIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.replicationTaskIdentifier)
      .optionallyWith(
        replicationTaskSettings.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.replicationTaskSettings)
      .optionallyWith(
        sourceEndpointArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceEndpointArn)
      .optionallyWith(
        tableMappings.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.tableMappings)
      .optionallyWith(
        targetEndpointArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.targetEndpointArn)
      .optionallyWith(
        taskData.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.taskData)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDmsReplicationTaskDetails.ReadOnly =
    zio.aws.securityhub.model.AwsDmsReplicationTaskDetails.wrap(buildAwsValue())
}
object AwsDmsReplicationTaskDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationTaskDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsDmsReplicationTaskDetails =
      zio.aws.securityhub.model.AwsDmsReplicationTaskDetails(
        cdcStartPosition.map(value => value),
        cdcStartTime.map(value => value),
        cdcStopPosition.map(value => value),
        migrationType.map(value => value),
        id.map(value => value),
        resourceIdentifier.map(value => value),
        replicationInstanceArn.map(value => value),
        replicationTaskIdentifier.map(value => value),
        replicationTaskSettings.map(value => value),
        sourceEndpointArn.map(value => value),
        tableMappings.map(value => value),
        targetEndpointArn.map(value => value),
        taskData.map(value => value)
      )
    def cdcStartPosition: Optional[NonEmptyString]
    def cdcStartTime: Optional[NonEmptyString]
    def cdcStopPosition: Optional[NonEmptyString]
    def migrationType: Optional[NonEmptyString]
    def id: Optional[NonEmptyString]
    def resourceIdentifier: Optional[NonEmptyString]
    def replicationInstanceArn: Optional[NonEmptyString]
    def replicationTaskIdentifier: Optional[NonEmptyString]
    def replicationTaskSettings: Optional[NonEmptyString]
    def sourceEndpointArn: Optional[NonEmptyString]
    def tableMappings: Optional[NonEmptyString]
    def targetEndpointArn: Optional[NonEmptyString]
    def taskData: Optional[NonEmptyString]
    def getCdcStartPosition: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cdcStartPosition", cdcStartPosition)
    def getCdcStartTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cdcStartTime", cdcStartTime)
    def getCdcStopPosition: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cdcStopPosition", cdcStopPosition)
    def getMigrationType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("migrationType", migrationType)
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getResourceIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getReplicationInstanceArn: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("replicationInstanceArn", replicationInstanceArn)
    def getReplicationTaskIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "replicationTaskIdentifier",
        replicationTaskIdentifier
      )
    def getReplicationTaskSettings: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "replicationTaskSettings",
        replicationTaskSettings
      )
    def getSourceEndpointArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceEndpointArn", sourceEndpointArn)
    def getTableMappings: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tableMappings", tableMappings)
    def getTargetEndpointArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("targetEndpointArn", targetEndpointArn)
    def getTaskData: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("taskData", taskData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationTaskDetails
  ) extends zio.aws.securityhub.model.AwsDmsReplicationTaskDetails.ReadOnly {
    override val cdcStartPosition: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cdcStartPosition())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val cdcStartTime: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStartTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val cdcStopPosition: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cdcStopPosition())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val migrationType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.migrationType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val resourceIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val replicationInstanceArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val replicationTaskIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val replicationTaskSettings: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskSettings())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val sourceEndpointArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceEndpointArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val tableMappings: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.tableMappings())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val targetEndpointArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetEndpointArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val taskData: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.taskData())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationTaskDetails
  ): zio.aws.securityhub.model.AwsDmsReplicationTaskDetails.ReadOnly =
    new Wrapper(impl)
}
