package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectLogsConfigDetails(
    cloudWatchLogs: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
    ] = Optional.Absent,
    s3Logs: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails = {
    import AwsCodeBuildProjectLogsConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails
      .builder()
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(s3Logs.map(value => value.buildAwsValue()))(_.s3Logs)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails
      .wrap(buildAwsValue())
}
object AwsCodeBuildProjectLogsConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails =
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails(
        cloudWatchLogs.map(value => value.asEditable),
        s3Logs.map(value => value.asEditable)
      )
    def cloudWatchLogs: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.ReadOnly
    ]
    def s3Logs: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails.ReadOnly
    ]
    def getCloudWatchLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getS3Logs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("s3Logs", s3Logs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails.ReadOnly {
    override val cloudWatchLogs: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogs())
      .map(value =>
        zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
          .wrap(value)
      )
    override val s3Logs: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Logs())
      .map(value =>
        zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails
  ): zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails.ReadOnly =
    new Wrapper(impl)
}
