package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectEnvironment(
    certificate: Optional[NonEmptyString] = Optional.Absent,
    environmentVariables: Optional[Iterable[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails
    ]] = Optional.Absent,
    privilegedMode: Optional[Boolean] = Optional.Absent,
    imagePullCredentialsType: Optional[NonEmptyString] = Optional.Absent,
    registryCredential: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential
    ] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironment = {
    import AwsCodeBuildProjectEnvironment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironment
      .builder()
      .optionallyWith(
        certificate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.certificate)
      .optionallyWith(
        environmentVariables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentVariables)
      .optionallyWith(privilegedMode.map(value => value: java.lang.Boolean))(
        _.privilegedMode
      )
      .optionallyWith(
        imagePullCredentialsType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.imagePullCredentialsType)
      .optionallyWith(registryCredential.map(value => value.buildAwsValue()))(
        _.registryCredential
      )
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment
      .wrap(buildAwsValue())
}
object AwsCodeBuildProjectEnvironment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment =
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment(
        certificate.map(value => value),
        environmentVariables.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privilegedMode.map(value => value),
        imagePullCredentialsType.map(value => value),
        registryCredential.map(value => value.asEditable),
        `type`.map(value => value)
      )
    def certificate: Optional[NonEmptyString]
    def environmentVariables: Optional[List[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.ReadOnly
    ]]
    def privilegedMode: Optional[Boolean]
    def imagePullCredentialsType: Optional[NonEmptyString]
    def registryCredential: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential.ReadOnly
    ]
    def `type`: Optional[NonEmptyString]
    def getCertificate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getEnvironmentVariables: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.ReadOnly
    ]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
    def getPrivilegedMode: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privilegedMode", privilegedMode)
    def getImagePullCredentialsType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "imagePullCredentialsType",
        imagePullCredentialsType
      )
    def getRegistryCredential: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential.ReadOnly
    ] = AwsError.unwrapOptionField("registryCredential", registryCredential)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironment
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment.ReadOnly {
    override val certificate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.certificate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val environmentVariables: Optional[List[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentVariables())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails
            .wrap(item)
        }.toList
      )
    override val privilegedMode: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.privilegedMode())
      .map(value => value: Boolean)
    override val imagePullCredentialsType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imagePullCredentialsType())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val registryCredential: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.registryCredential())
      .map(value =>
        zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential
          .wrap(value)
      )
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironment
  ): zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment.ReadOnly =
    new Wrapper(impl)
}
