package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionOrigins(
    items: Optional[
      Iterable[zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOrigins = {
    import AwsCloudFrontDistributionOrigins.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOrigins
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionOrigins.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionOrigins
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionOrigins {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOrigins
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsCloudFrontDistributionOrigins =
      zio.aws.securityhub.model.AwsCloudFrontDistributionOrigins(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def items: Optional[List[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem.ReadOnly
    ]]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOrigins
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionOrigins.ReadOnly {
    override val items: Optional[List[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOrigins
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionOrigins.ReadOnly =
    new Wrapper(impl)
}
