package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsBackupBackupPlanBackupPlanDetails(
    backupPlanName: Optional[NonEmptyString] = Optional.Absent,
    advancedBackupSettings: Optional[Iterable[
      zio.aws.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails
    ]] = Optional.Absent,
    backupPlanRule: Optional[
      Iterable[zio.aws.securityhub.model.AwsBackupBackupPlanRuleDetails]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanBackupPlanDetails = {
    import AwsBackupBackupPlanBackupPlanDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanBackupPlanDetails
      .builder()
      .optionallyWith(
        backupPlanName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.backupPlanName)
      .optionallyWith(
        advancedBackupSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.advancedBackupSettings)
      .optionallyWith(
        backupPlanRule.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backupPlanRule)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsBackupBackupPlanBackupPlanDetails.ReadOnly =
    zio.aws.securityhub.model.AwsBackupBackupPlanBackupPlanDetails
      .wrap(buildAwsValue())
}
object AwsBackupBackupPlanBackupPlanDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanBackupPlanDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsBackupBackupPlanBackupPlanDetails =
      zio.aws.securityhub.model.AwsBackupBackupPlanBackupPlanDetails(
        backupPlanName.map(value => value),
        advancedBackupSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        backupPlanRule.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def backupPlanName: Optional[NonEmptyString]
    def advancedBackupSettings: Optional[List[
      zio.aws.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails.ReadOnly
    ]]
    def backupPlanRule: Optional[
      List[zio.aws.securityhub.model.AwsBackupBackupPlanRuleDetails.ReadOnly]
    ]
    def getBackupPlanName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("backupPlanName", backupPlanName)
    def getAdvancedBackupSettings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "advancedBackupSettings",
      advancedBackupSettings
    )
    def getBackupPlanRule: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsBackupBackupPlanRuleDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("backupPlanRule", backupPlanRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanBackupPlanDetails
  ) extends zio.aws.securityhub.model.AwsBackupBackupPlanBackupPlanDetails.ReadOnly {
    override val backupPlanName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupPlanName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val advancedBackupSettings: Optional[List[
      zio.aws.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.advancedBackupSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails
            .wrap(item)
        }.toList
      )
    override val backupPlanRule: Optional[
      List[zio.aws.securityhub.model.AwsBackupBackupPlanRuleDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanRule())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsBackupBackupPlanRuleDetails.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanBackupPlanDetails
  ): zio.aws.securityhub.model.AwsBackupBackupPlanBackupPlanDetails.ReadOnly =
    new Wrapper(impl)
}
