package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails(
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails = {
    import AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails
      .wrap(buildAwsValue())
}
object AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails =
      zio.aws.securityhub.model
        .AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails(
          enabled.map(value => value)
        )
    def enabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails
  ) extends zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails
  ): zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.ReadOnly =
    new Wrapper(impl)
}
