package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAthenaWorkGroupConfigurationResultConfigurationDetails(
    encryptionConfiguration: Optional[
      zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails = {
    import AwsAthenaWorkGroupConfigurationResultConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails
      .builder()
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsAthenaWorkGroupConfigurationResultConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails =
      zio.aws.securityhub.model
        .AwsAthenaWorkGroupConfigurationResultConfigurationDetails(
          encryptionConfiguration.map(value => value.asEditable)
        )
    def encryptionConfiguration: Optional[
      zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails.ReadOnly
    ]
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails.ReadOnly {
    override val encryptionConfiguration: Optional[
      zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails
  ): zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
