package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAmazonMqBrokerUsersDetails(
    pendingChange: Optional[NonEmptyString] = Optional.Absent,
    username: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerUsersDetails = {
    import AwsAmazonMqBrokerUsersDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerUsersDetails
      .builder()
      .optionallyWith(
        pendingChange.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.pendingChange)
      .optionallyWith(
        username.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.username)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAmazonMqBrokerUsersDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAmazonMqBrokerUsersDetails
      .wrap(buildAwsValue())
}
object AwsAmazonMqBrokerUsersDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerUsersDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsAmazonMqBrokerUsersDetails =
      zio.aws.securityhub.model.AwsAmazonMqBrokerUsersDetails(
        pendingChange.map(value => value),
        username.map(value => value)
      )
    def pendingChange: Optional[NonEmptyString]
    def username: Optional[NonEmptyString]
    def getPendingChange: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("pendingChange", pendingChange)
    def getUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerUsersDetails
  ) extends zio.aws.securityhub.model.AwsAmazonMqBrokerUsersDetails.ReadOnly {
    override val pendingChange: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingChange())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val username: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerUsersDetails
  ): zio.aws.securityhub.model.AwsAmazonMqBrokerUsersDetails.ReadOnly =
    new Wrapper(impl)
}
