package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAmazonMqBrokerLogsPendingDetails(
    audit: Optional[Boolean] = Optional.Absent,
    general: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails = {
    import AwsAmazonMqBrokerLogsPendingDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails
      .builder()
      .optionallyWith(audit.map(value => value: java.lang.Boolean))(_.audit)
      .optionallyWith(general.map(value => value: java.lang.Boolean))(_.general)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails
      .wrap(buildAwsValue())
}
object AwsAmazonMqBrokerLogsPendingDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails =
      zio.aws.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails(
        audit.map(value => value),
        general.map(value => value)
      )
    def audit: Optional[Boolean]
    def general: Optional[Boolean]
    def getAudit: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("audit", audit)
    def getGeneral: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("general", general)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails
  ) extends zio.aws.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails.ReadOnly {
    override val audit: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.audit())
      .map(value => value: Boolean)
    override val general: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.general())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails
  ): zio.aws.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails.ReadOnly =
    new Wrapper(impl)
}
