package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAmazonMqBrokerDetails(
    authenticationStrategy: Optional[NonEmptyString] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    brokerArn: Optional[NonEmptyString] = Optional.Absent,
    brokerName: Optional[NonEmptyString] = Optional.Absent,
    deploymentMode: Optional[NonEmptyString] = Optional.Absent,
    encryptionOptions: Optional[
      zio.aws.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails
    ] = Optional.Absent,
    engineType: Optional[NonEmptyString] = Optional.Absent,
    engineVersion: Optional[NonEmptyString] = Optional.Absent,
    hostInstanceType: Optional[NonEmptyString] = Optional.Absent,
    brokerId: Optional[NonEmptyString] = Optional.Absent,
    ldapServerMetadata: Optional[
      zio.aws.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails
    ] = Optional.Absent,
    logs: Optional[zio.aws.securityhub.model.AwsAmazonMqBrokerLogsDetails] =
      Optional.Absent,
    maintenanceWindowStartTime: Optional[
      zio.aws.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails
    ] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    securityGroups: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    storageType: Optional[NonEmptyString] = Optional.Absent,
    subnetIds: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    users: Optional[
      Iterable[zio.aws.securityhub.model.AwsAmazonMqBrokerUsersDetails]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerDetails = {
    import AwsAmazonMqBrokerDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerDetails
      .builder()
      .optionallyWith(
        authenticationStrategy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.authenticationStrategy)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        brokerArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.brokerArn)
      .optionallyWith(
        brokerName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.brokerName)
      .optionallyWith(
        deploymentMode.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.deploymentMode)
      .optionallyWith(encryptionOptions.map(value => value.buildAwsValue()))(
        _.encryptionOptions
      )
      .optionallyWith(
        engineType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.engineType)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        hostInstanceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.hostInstanceType)
      .optionallyWith(
        brokerId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.brokerId)
      .optionallyWith(ldapServerMetadata.map(value => value.buildAwsValue()))(
        _.ldapServerMetadata
      )
      .optionallyWith(logs.map(value => value.buildAwsValue()))(_.logs)
      .optionallyWith(
        maintenanceWindowStartTime.map(value => value.buildAwsValue())
      )(_.maintenanceWindowStartTime)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        storageType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.storageType)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsAmazonMqBrokerDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAmazonMqBrokerDetails.wrap(buildAwsValue())
}
object AwsAmazonMqBrokerDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsAmazonMqBrokerDetails =
      zio.aws.securityhub.model.AwsAmazonMqBrokerDetails(
        authenticationStrategy.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        brokerArn.map(value => value),
        brokerName.map(value => value),
        deploymentMode.map(value => value),
        encryptionOptions.map(value => value.asEditable),
        engineType.map(value => value),
        engineVersion.map(value => value),
        hostInstanceType.map(value => value),
        brokerId.map(value => value),
        ldapServerMetadata.map(value => value.asEditable),
        logs.map(value => value.asEditable),
        maintenanceWindowStartTime.map(value => value.asEditable),
        publiclyAccessible.map(value => value),
        securityGroups.map(value => value),
        storageType.map(value => value),
        subnetIds.map(value => value),
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def authenticationStrategy: Optional[NonEmptyString]
    def autoMinorVersionUpgrade: Optional[Boolean]
    def brokerArn: Optional[NonEmptyString]
    def brokerName: Optional[NonEmptyString]
    def deploymentMode: Optional[NonEmptyString]
    def encryptionOptions: Optional[
      zio.aws.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails.ReadOnly
    ]
    def engineType: Optional[NonEmptyString]
    def engineVersion: Optional[NonEmptyString]
    def hostInstanceType: Optional[NonEmptyString]
    def brokerId: Optional[NonEmptyString]
    def ldapServerMetadata: Optional[
      zio.aws.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails.ReadOnly
    ]
    def logs: Optional[
      zio.aws.securityhub.model.AwsAmazonMqBrokerLogsDetails.ReadOnly
    ]
    def maintenanceWindowStartTime: Optional[
      zio.aws.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.ReadOnly
    ]
    def publiclyAccessible: Optional[Boolean]
    def securityGroups: Optional[List[NonEmptyString]]
    def storageType: Optional[NonEmptyString]
    def subnetIds: Optional[List[NonEmptyString]]
    def users: Optional[
      List[zio.aws.securityhub.model.AwsAmazonMqBrokerUsersDetails.ReadOnly]
    ]
    def getAuthenticationStrategy: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("authenticationStrategy", authenticationStrategy)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getBrokerArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("brokerArn", brokerArn)
    def getBrokerName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("brokerName", brokerName)
    def getDeploymentMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("deploymentMode", deploymentMode)
    def getEncryptionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("encryptionOptions", encryptionOptions)
    def getEngineType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineType", engineType)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getHostInstanceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostInstanceType", hostInstanceType)
    def getBrokerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("brokerId", brokerId)
    def getLdapServerMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("ldapServerMetadata", ldapServerMetadata)
    def getLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAmazonMqBrokerLogsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("logs", logs)
    def getMaintenanceWindowStartTime: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "maintenanceWindowStartTime",
      maintenanceWindowStartTime
    )
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getSecurityGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getStorageType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getSubnetIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getUsers: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsAmazonMqBrokerUsersDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("users", users)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerDetails
  ) extends zio.aws.securityhub.model.AwsAmazonMqBrokerDetails.ReadOnly {
    override val authenticationStrategy: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationStrategy())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val autoMinorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: Boolean)
    override val brokerArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.brokerArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val brokerName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.brokerName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deploymentMode: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentMode())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val encryptionOptions: Optional[
      zio.aws.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails
          .wrap(value)
      )
    override val engineType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engineType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val engineVersion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val hostInstanceType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostInstanceType())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val brokerId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.brokerId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ldapServerMetadata: Optional[
      zio.aws.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ldapServerMetadata())
      .map(value =>
        zio.aws.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails
          .wrap(value)
      )
    override val logs: Optional[
      zio.aws.securityhub.model.AwsAmazonMqBrokerLogsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logs())
      .map(value =>
        zio.aws.securityhub.model.AwsAmazonMqBrokerLogsDetails.wrap(value)
      )
    override val maintenanceWindowStartTime: Optional[
      zio.aws.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceWindowStartTime())
      .map(value =>
        zio.aws.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails
          .wrap(value)
      )
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val securityGroups: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val storageType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subnetIds: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val users: Optional[
      List[zio.aws.securityhub.model.AwsAmazonMqBrokerUsersDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.users())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsAmazonMqBrokerUsersDetails.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerDetails
  ): zio.aws.securityhub.model.AwsAmazonMqBrokerDetails.ReadOnly = new Wrapper(
    impl
  )
}
