package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Action(
    actionType: Optional[NonEmptyString] = Optional.Absent,
    networkConnectionAction: Optional[
      zio.aws.securityhub.model.NetworkConnectionAction
    ] = Optional.Absent,
    awsApiCallAction: Optional[zio.aws.securityhub.model.AwsApiCallAction] =
      Optional.Absent,
    dnsRequestAction: Optional[zio.aws.securityhub.model.DnsRequestAction] =
      Optional.Absent,
    portProbeAction: Optional[zio.aws.securityhub.model.PortProbeAction] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Action = {
    import Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Action
      .builder()
      .optionallyWith(
        actionType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.actionType)
      .optionallyWith(
        networkConnectionAction.map(value => value.buildAwsValue())
      )(_.networkConnectionAction)
      .optionallyWith(awsApiCallAction.map(value => value.buildAwsValue()))(
        _.awsApiCallAction
      )
      .optionallyWith(dnsRequestAction.map(value => value.buildAwsValue()))(
        _.dnsRequestAction
      )
      .optionallyWith(portProbeAction.map(value => value.buildAwsValue()))(
        _.portProbeAction
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Action.ReadOnly =
    zio.aws.securityhub.model.Action.wrap(buildAwsValue())
}
object Action {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Action
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Action =
      zio.aws.securityhub.model.Action(
        actionType.map(value => value),
        networkConnectionAction.map(value => value.asEditable),
        awsApiCallAction.map(value => value.asEditable),
        dnsRequestAction.map(value => value.asEditable),
        portProbeAction.map(value => value.asEditable)
      )
    def actionType: Optional[NonEmptyString]
    def networkConnectionAction
        : Optional[zio.aws.securityhub.model.NetworkConnectionAction.ReadOnly]
    def awsApiCallAction
        : Optional[zio.aws.securityhub.model.AwsApiCallAction.ReadOnly]
    def dnsRequestAction
        : Optional[zio.aws.securityhub.model.DnsRequestAction.ReadOnly]
    def portProbeAction
        : Optional[zio.aws.securityhub.model.PortProbeAction.ReadOnly]
    def getActionType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getNetworkConnectionAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.NetworkConnectionAction.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkConnectionAction",
      networkConnectionAction
    )
    def getAwsApiCallAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiCallAction.ReadOnly
    ] = AwsError.unwrapOptionField("awsApiCallAction", awsApiCallAction)
    def getDnsRequestAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.DnsRequestAction.ReadOnly
    ] = AwsError.unwrapOptionField("dnsRequestAction", dnsRequestAction)
    def getPortProbeAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.PortProbeAction.ReadOnly
    ] = AwsError.unwrapOptionField("portProbeAction", portProbeAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Action
  ) extends zio.aws.securityhub.model.Action.ReadOnly {
    override val actionType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.actionType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val networkConnectionAction
        : Optional[zio.aws.securityhub.model.NetworkConnectionAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConnectionAction())
        .map(value =>
          zio.aws.securityhub.model.NetworkConnectionAction.wrap(value)
        )
    override val awsApiCallAction
        : Optional[zio.aws.securityhub.model.AwsApiCallAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsApiCallAction())
        .map(value => zio.aws.securityhub.model.AwsApiCallAction.wrap(value))
    override val dnsRequestAction
        : Optional[zio.aws.securityhub.model.DnsRequestAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsRequestAction())
        .map(value => zio.aws.securityhub.model.DnsRequestAction.wrap(value))
    override val portProbeAction
        : Optional[zio.aws.securityhub.model.PortProbeAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portProbeAction())
        .map(value => zio.aws.securityhub.model.PortProbeAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Action
  ): zio.aws.securityhub.model.Action.ReadOnly = new Wrapper(impl)
}
