package zio.aws.securityhub
import zio.prelude.Subtype
import zio.aws.securityhub.model.primitives.{
  TagValue,
  TagKey,
  Integer,
  NonEmptyString
}
import java.time.Instant
import zio.aws.securityhub.model.primitives.CrossAccountMaxResults.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.securityhub.model.primitives.AccountId.Type
    object AdminsMaxResults extends Subtype[Int]
    type AdminsMaxResults =
      zio.aws.securityhub.model.primitives.AdminsMaxResults.Type
    object AwsIamRoleAssumeRolePolicyDocument extends Subtype[String]
    type AwsIamRoleAssumeRolePolicyDocument =
      zio.aws.securityhub.model.primitives.AwsIamRoleAssumeRolePolicyDocument.Type
    object AwsLambdaLayerVersionNumber extends Subtype[Long]
    type AwsLambdaLayerVersionNumber =
      zio.aws.securityhub.model.primitives.AwsLambdaLayerVersionNumber.Type
    object CrossAccountMaxResults extends Subtype[Int]
    type CrossAccountMaxResults =
      zio.aws.securityhub.model.primitives.CrossAccountMaxResults.Type
    type Integer = Int
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.securityhub.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.securityhub.model.primitives.NextToken.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString.Type
    object RatioScale extends Subtype[Int]
    type RatioScale = zio.aws.securityhub.model.primitives.RatioScale.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.securityhub.model.primitives.ResourceArn.Type
    object RuleOrderValue extends Subtype[Int]
    type RuleOrderValue =
      zio.aws.securityhub.model.primitives.RuleOrderValue.Type
    object SizeBytes extends Subtype[Long]
    type SizeBytes = zio.aws.securityhub.model.primitives.SizeBytes.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.securityhub.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.securityhub.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.securityhub.model.primitives.Timestamp.Type
  }
  type AccountDetailsList = List[zio.aws.securityhub.model.AccountDetails]
  type AccountIdList = List[NonEmptyString]
  type ActionList = List[zio.aws.securityhub.model.AutomationRulesAction]
  type ActionTargetList = List[zio.aws.securityhub.model.ActionTarget]
  type AdjustmentList = List[zio.aws.securityhub.model.Adjustment]
  type AdminAccounts = List[zio.aws.securityhub.model.AdminAccount]
  type ArnList = List[NonEmptyString]
  type AssociatedStandardsList =
    List[zio.aws.securityhub.model.AssociatedStandard]
  type AssociationSetList =
    List[zio.aws.securityhub.model.AssociationSetDetails]
  type AutomationRulesArnsList = List[NonEmptyString]
  type AutomationRulesConfigList =
    List[zio.aws.securityhub.model.AutomationRulesConfig]
  type AutomationRulesMetadataList =
    List[zio.aws.securityhub.model.AutomationRulesMetadata]
  type AvailabilityZones = List[zio.aws.securityhub.model.AvailabilityZone]
  type AwsAmazonMqBrokerUsersList =
    List[zio.aws.securityhub.model.AwsAmazonMqBrokerUsersDetails]
  type AwsApiGatewayMethodSettingsList =
    List[zio.aws.securityhub.model.AwsApiGatewayMethodSettings]
  type AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersList = List[
    zio.aws.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails
  ]
  type AwsAutoScalingAutoScalingGroupAvailabilityZonesList = List[
    zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails
  ]
  type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesList =
    List[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails
    ]
  type AwsAutoScalingLaunchConfigurationBlockDeviceMappingsList = List[
    zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
  ]
  type AwsBackupBackupPlanAdvancedBackupSettingsList = List[
    zio.aws.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails
  ]
  type AwsBackupBackupPlanRuleCopyActionsList =
    List[zio.aws.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails]
  type AwsBackupBackupPlanRuleList =
    List[zio.aws.securityhub.model.AwsBackupBackupPlanRuleDetails]
  type AwsCertificateManagerCertificateDomainValidationOptions = List[
    zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
  ]
  type AwsCertificateManagerCertificateExtendedKeyUsages = List[
    zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage
  ]
  type AwsCertificateManagerCertificateKeyUsages =
    List[zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage]
  type AwsCloudFormationStackOutputsList =
    List[zio.aws.securityhub.model.AwsCloudFormationStackOutputsDetails]
  type AwsCloudFrontDistributionCacheBehaviorsItemList =
    List[zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehavior]
  type AwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemList =
    List[Integer]
  type AwsCloudFrontDistributionOriginGroupsItemList =
    List[zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup]
  type AwsCloudFrontDistributionOriginItemList =
    List[zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem]
  type AwsCloudWatchAlarmDimensionsList =
    List[zio.aws.securityhub.model.AwsCloudWatchAlarmDimensionsDetails]
  type AwsCodeBuildProjectArtifactsList =
    List[zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails]
  type AwsCodeBuildProjectEnvironmentEnvironmentVariablesList = List[
    zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails
  ]
  type AwsDmsReplicationInstanceVpcSecurityGroupsList = List[
    zio.aws.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails
  ]
  type AwsDynamoDbTableAttributeDefinitionList =
    List[zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition]
  type AwsDynamoDbTableGlobalSecondaryIndexList =
    List[zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex]
  type AwsDynamoDbTableKeySchemaList =
    List[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema]
  type AwsDynamoDbTableLocalSecondaryIndexList =
    List[zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex]
  type AwsDynamoDbTableReplicaGlobalSecondaryIndexList =
    List[zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex]
  type AwsDynamoDbTableReplicaList =
    List[zio.aws.securityhub.model.AwsDynamoDbTableReplica]
  type AwsEc2InstanceNetworkInterfacesList =
    List[zio.aws.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails]
  type AwsEc2LaunchTemplateDataBlockDeviceMappingSetList = List[
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails
  ]
  type AwsEc2LaunchTemplateDataElasticGpuSpecificationSetList = List[
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails
  ]
  type AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetList = List[
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails
  ]
  type AwsEc2LaunchTemplateDataLicenseSetList =
    List[zio.aws.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails]
  type AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesList = List[
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails
  ]
  type AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesList = List[
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails
  ]
  type AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesList = List[
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails
  ]
  type AwsEc2LaunchTemplateDataNetworkInterfaceSetList = List[
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails
  ]
  type AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesList = List[
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails
  ]
  type AwsEc2NetworkAclAssociationList =
    List[zio.aws.securityhub.model.AwsEc2NetworkAclAssociation]
  type AwsEc2NetworkAclEntryList =
    List[zio.aws.securityhub.model.AwsEc2NetworkAclEntry]
  type AwsEc2NetworkInterfaceIpV6AddressList =
    List[zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail]
  type AwsEc2NetworkInterfacePrivateIpAddressList =
    List[zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail]
  type AwsEc2NetworkInterfaceSecurityGroupList =
    List[zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup]
  type AwsEc2SecurityGroupIpPermissionList =
    List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission]
  type AwsEc2SecurityGroupIpRangeList =
    List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange]
  type AwsEc2SecurityGroupIpv6RangeList =
    List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range]
  type AwsEc2SecurityGroupPrefixListIdList =
    List[zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId]
  type AwsEc2SecurityGroupUserIdGroupPairList =
    List[zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair]
  type AwsEc2VolumeAttachmentList =
    List[zio.aws.securityhub.model.AwsEc2VolumeAttachment]
  type AwsEc2VpcEndpointServiceServiceTypeList =
    List[zio.aws.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails]
  type AwsEc2VpnConnectionOptionsTunnelOptionsList = List[
    zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
  ]
  type AwsEc2VpnConnectionRoutesList =
    List[zio.aws.securityhub.model.AwsEc2VpnConnectionRoutesDetails]
  type AwsEc2VpnConnectionVgwTelemetryList =
    List[zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails]
  type AwsEcsClusterClusterSettingsList =
    List[zio.aws.securityhub.model.AwsEcsClusterClusterSettingsDetails]
  type AwsEcsClusterDefaultCapacityProviderStrategyList = List[
    zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails
  ]
  type AwsEcsContainerDetailsList =
    List[zio.aws.securityhub.model.AwsEcsContainerDetails]
  type AwsEcsServiceCapacityProviderStrategyList =
    List[zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails]
  type AwsEcsServiceLoadBalancersList =
    List[zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails]
  type AwsEcsServicePlacementConstraintsList =
    List[zio.aws.securityhub.model.AwsEcsServicePlacementConstraintsDetails]
  type AwsEcsServicePlacementStrategiesList =
    List[zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails]
  type AwsEcsServiceServiceRegistriesList =
    List[zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails]
  type AwsEcsTaskDefinitionContainerDefinitionsDependsOnList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
  ]
  type AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails
  ]
  type AwsEcsTaskDefinitionContainerDefinitionsEnvironmentList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails
  ]
  type AwsEcsTaskDefinitionContainerDefinitionsExtraHostsList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
  ]
  type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesList =
    List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
    ]
  type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
  ]
  type AwsEcsTaskDefinitionContainerDefinitionsList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
  ]
  type AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsList =
    List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
    ]
  type AwsEcsTaskDefinitionContainerDefinitionsMountPointsList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
  ]
  type AwsEcsTaskDefinitionContainerDefinitionsPortMappingsList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
  ]
  type AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
  ]
  type AwsEcsTaskDefinitionContainerDefinitionsSecretsList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails
  ]
  type AwsEcsTaskDefinitionContainerDefinitionsSystemControlsList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails
  ]
  type AwsEcsTaskDefinitionContainerDefinitionsUlimitsList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
  ]
  type AwsEcsTaskDefinitionContainerDefinitionsVolumesFromList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
  ]
  type AwsEcsTaskDefinitionInferenceAcceleratorsList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
  ]
  type AwsEcsTaskDefinitionPlacementConstraintsList = List[
    zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails
  ]
  type AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesList =
    List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
    ]
  type AwsEcsTaskDefinitionVolumesList =
    List[zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails]
  type AwsEcsTaskVolumeDetailsList =
    List[zio.aws.securityhub.model.AwsEcsTaskVolumeDetails]
  type AwsEksClusterLoggingClusterLoggingList =
    List[zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails]
  type AwsElasticBeanstalkEnvironmentEnvironmentLinks = List[
    zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink
  ]
  type AwsElasticBeanstalkEnvironmentOptionSettings =
    List[zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting]
  type AwsElbAppCookieStickinessPolicies =
    List[zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy]
  type AwsElbLbCookieStickinessPolicies =
    List[zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy]
  type AwsElbLoadBalancerAdditionalAttributeList =
    List[zio.aws.securityhub.model.AwsElbLoadBalancerAdditionalAttribute]
  type AwsElbLoadBalancerBackendServerDescriptions =
    List[zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription]
  type AwsElbLoadBalancerInstances =
    List[zio.aws.securityhub.model.AwsElbLoadBalancerInstance]
  type AwsElbLoadBalancerListenerDescriptions =
    List[zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription]
  type AwsElbv2LoadBalancerAttributes =
    List[zio.aws.securityhub.model.AwsElbv2LoadBalancerAttribute]
  type AwsEventsEndpointEventBusesList =
    List[zio.aws.securityhub.model.AwsEventsEndpointEventBusesDetails]
  type AwsGuardDutyDetectorFeaturesList =
    List[zio.aws.securityhub.model.AwsGuardDutyDetectorFeaturesDetails]
  type AwsIamAttachedManagedPolicyList =
    List[zio.aws.securityhub.model.AwsIamAttachedManagedPolicy]
  type AwsIamGroupPolicyList = List[zio.aws.securityhub.model.AwsIamGroupPolicy]
  type AwsIamInstanceProfileList =
    List[zio.aws.securityhub.model.AwsIamInstanceProfile]
  type AwsIamInstanceProfileRoles =
    List[zio.aws.securityhub.model.AwsIamInstanceProfileRole]
  type AwsIamPolicyVersionList =
    List[zio.aws.securityhub.model.AwsIamPolicyVersion]
  type AwsIamRolePolicyList = List[zio.aws.securityhub.model.AwsIamRolePolicy]
  type AwsIamUserPolicyList = List[zio.aws.securityhub.model.AwsIamUserPolicy]
  type AwsLambdaFunctionLayerList =
    List[zio.aws.securityhub.model.AwsLambdaFunctionLayer]
  type AwsMountPointList = List[zio.aws.securityhub.model.AwsMountPoint]
  type AwsNetworkFirewallFirewallSubnetMappingsList = List[
    zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails
  ]
  type AwsRdsDbClusterAssociatedRoles =
    List[zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole]
  type AwsRdsDbClusterMembers =
    List[zio.aws.securityhub.model.AwsRdsDbClusterMember]
  type AwsRdsDbClusterOptionGroupMemberships =
    List[zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership]
  type AwsRdsDbClusterSnapshotDbClusterSnapshotAttributes = List[
    zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute
  ]
  type AwsRdsDbDomainMemberships =
    List[zio.aws.securityhub.model.AwsRdsDbDomainMembership]
  type AwsRdsDbInstanceAssociatedRoles =
    List[zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole]
  type AwsRdsDbInstanceVpcSecurityGroups =
    List[zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup]
  type AwsRdsDbOptionGroupMemberships =
    List[zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership]
  type AwsRdsDbParameterGroups =
    List[zio.aws.securityhub.model.AwsRdsDbParameterGroup]
  type AwsRdsDbProcessorFeatures =
    List[zio.aws.securityhub.model.AwsRdsDbProcessorFeature]
  type AwsRdsDbSecurityGroupEc2SecurityGroups =
    List[zio.aws.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup]
  type AwsRdsDbSecurityGroupIpRanges =
    List[zio.aws.securityhub.model.AwsRdsDbSecurityGroupIpRange]
  type AwsRdsDbStatusInfos = List[zio.aws.securityhub.model.AwsRdsDbStatusInfo]
  type AwsRdsDbSubnetGroupSubnets =
    List[zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnet]
  type AwsRedshiftClusterClusterNodes =
    List[zio.aws.securityhub.model.AwsRedshiftClusterClusterNode]
  type AwsRedshiftClusterClusterParameterGroups =
    List[zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup]
  type AwsRedshiftClusterClusterParameterStatusList =
    List[zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus]
  type AwsRedshiftClusterClusterSecurityGroups =
    List[zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup]
  type AwsRedshiftClusterDeferredMaintenanceWindows =
    List[zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow]
  type AwsRedshiftClusterIamRoles =
    List[zio.aws.securityhub.model.AwsRedshiftClusterIamRole]
  type AwsRedshiftClusterVpcSecurityGroups =
    List[zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup]
  type AwsRoute53HostedZoneNameServersList = List[NonEmptyString]
  type AwsRoute53HostedZoneVpcsList =
    List[zio.aws.securityhub.model.AwsRoute53HostedZoneVpcDetails]
  type AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsList =
    List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails
    ]
  type AwsS3BucketBucketLifecycleConfigurationRulesList = List[
    zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails
  ]
  type AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsList =
    List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails
    ]
  type AwsS3BucketBucketLifecycleConfigurationRulesTransitionsList = List[
    zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails
  ]
  type AwsS3BucketNotificationConfigurationDetails =
    List[zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationDetail]
  type AwsS3BucketNotificationConfigurationEvents = List[NonEmptyString]
  type AwsS3BucketNotificationConfigurationS3KeyFilterRules = List[
    zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule
  ]
  type AwsS3BucketServerSideEncryptionRules =
    List[zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionRule]
  type AwsS3BucketWebsiteConfigurationRoutingRules =
    List[zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule]
  type AwsSecurityFindingIdentifierList =
    List[zio.aws.securityhub.model.AwsSecurityFindingIdentifier]
  type AwsSecurityFindingList =
    List[zio.aws.securityhub.model.AwsSecurityFinding]
  type AwsSnsTopicSubscriptionList =
    List[zio.aws.securityhub.model.AwsSnsTopicSubscription]
  type AwsStepFunctionStateMachineLoggingConfigurationDestinationsList = List[
    zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails
  ]
  type AwsWafRateBasedRuleMatchPredicateList =
    List[zio.aws.securityhub.model.AwsWafRateBasedRuleMatchPredicate]
  type AwsWafRegionalRateBasedRuleMatchPredicateList =
    List[zio.aws.securityhub.model.AwsWafRegionalRateBasedRuleMatchPredicate]
  type AwsWafRegionalRuleGroupRulesList =
    List[zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesDetails]
  type AwsWafRegionalRulePredicateList =
    List[zio.aws.securityhub.model.AwsWafRegionalRulePredicateListDetails]
  type AwsWafRegionalWebAclRulesList =
    List[zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListDetails]
  type AwsWafRuleGroupRulesList =
    List[zio.aws.securityhub.model.AwsWafRuleGroupRulesDetails]
  type AwsWafRulePredicateList =
    List[zio.aws.securityhub.model.AwsWafRulePredicateListDetails]
  type AwsWafWebAclRuleList = List[zio.aws.securityhub.model.AwsWafWebAclRule]
  type AwsWafv2InsertHeadersList =
    List[zio.aws.securityhub.model.AwsWafv2CustomHttpHeader]
  type AwsWafv2RulesList = List[zio.aws.securityhub.model.AwsWafv2RulesDetails]
  type BatchImportFindingsRequestFindingList =
    List[zio.aws.securityhub.model.AwsSecurityFinding]
  type BatchUpdateFindingsUnprocessedFindingsList =
    List[zio.aws.securityhub.model.BatchUpdateFindingsUnprocessedFinding]
  type BooleanFilterList = List[zio.aws.securityhub.model.BooleanFilter]
  type CategoryList = List[NonEmptyString]
  type Cells = List[zio.aws.securityhub.model.Cell]
  type CidrBlockAssociationList =
    List[zio.aws.securityhub.model.CidrBlockAssociation]
  type CustomDataIdentifiersDetectionsList =
    List[zio.aws.securityhub.model.CustomDataIdentifiersDetections]
  type CvssList = List[zio.aws.securityhub.model.Cvss]
  type DateFilterList = List[zio.aws.securityhub.model.DateFilter]
  type FieldMap = Map[NonEmptyString, NonEmptyString]
  type FilePathList = List[zio.aws.securityhub.model.FilePaths]
  type FindingAggregatorList = List[zio.aws.securityhub.model.FindingAggregator]
  type FindingHistoryRecordList =
    List[zio.aws.securityhub.model.FindingHistoryRecord]
  type FindingHistoryUpdatesList =
    List[zio.aws.securityhub.model.FindingHistoryUpdate]
  type FirewallPolicyStatefulRuleGroupReferencesList = List[
    zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
  ]
  type FirewallPolicyStatelessCustomActionsList =
    List[zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails]
  type FirewallPolicyStatelessRuleGroupReferencesList = List[
    zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails
  ]
  type ImportFindingsErrorList =
    List[zio.aws.securityhub.model.ImportFindingsError]
  type InsightList = List[zio.aws.securityhub.model.Insight]
  type InsightResultValueList =
    List[zio.aws.securityhub.model.InsightResultValue]
  type IntegerList = List[Integer]
  type IntegrationTypeList = List[zio.aws.securityhub.model.IntegrationType]
  type InvitationList = List[zio.aws.securityhub.model.Invitation]
  type IpFilterList = List[zio.aws.securityhub.model.IpFilter]
  type Ipv6CidrBlockAssociationList =
    List[zio.aws.securityhub.model.Ipv6CidrBlockAssociation]
  type KeywordFilterList = List[zio.aws.securityhub.model.KeywordFilter]
  type MalwareList = List[zio.aws.securityhub.model.Malware]
  type MapFilterList = List[zio.aws.securityhub.model.MapFilter]
  type MemberList = List[zio.aws.securityhub.model.Member]
  type NetworkPathList = List[zio.aws.securityhub.model.NetworkPathComponent]
  type NonEmptyStringList = List[NonEmptyString]
  type NumberFilterList = List[zio.aws.securityhub.model.NumberFilter]
  type Pages = List[zio.aws.securityhub.model.Page]
  type PortProbeDetailList = List[zio.aws.securityhub.model.PortProbeDetail]
  type PortRangeList = List[zio.aws.securityhub.model.PortRange]
  type ProductSubscriptionArnList = List[NonEmptyString]
  type ProductsList = List[zio.aws.securityhub.model.Product]
  type PropagatingVgwSetList =
    List[zio.aws.securityhub.model.PropagatingVgwSetDetails]
  type Ranges = List[zio.aws.securityhub.model.Range]
  type Records = List[zio.aws.securityhub.model.Record]
  type RelatedFindingList = List[zio.aws.securityhub.model.RelatedFinding]
  type RelatedRequirementsList = List[NonEmptyString]
  type ResourceList = List[zio.aws.securityhub.model.Resource]
  type ResultList = List[zio.aws.securityhub.model.Result]
  type RouteSetList = List[zio.aws.securityhub.model.RouteSetDetails]
  type RuleGroupSourceCustomActionsList =
    List[zio.aws.securityhub.model.RuleGroupSourceCustomActionsDetails]
  type RuleGroupSourceStatefulRulesList =
    List[zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails]
  type RuleGroupSourceStatefulRulesOptionsList =
    List[zio.aws.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails]
  type RuleGroupSourceStatefulRulesRuleOptionsSettingsList =
    List[NonEmptyString]
  type RuleGroupSourceStatelessRuleMatchAttributesDestinationPortsList = List[
    zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts
  ]
  type RuleGroupSourceStatelessRuleMatchAttributesDestinationsList = List[
    zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations
  ]
  type RuleGroupSourceStatelessRuleMatchAttributesProtocolsList = List[Integer]
  type RuleGroupSourceStatelessRuleMatchAttributesSourcePortsList = List[
    zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts
  ]
  type RuleGroupSourceStatelessRuleMatchAttributesSourcesList = List[
    zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources
  ]
  type RuleGroupSourceStatelessRuleMatchAttributesTcpFlagsList = List[
    zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags
  ]
  type RuleGroupSourceStatelessRulesList =
    List[zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails]
  type SecurityControlDefinitions =
    List[zio.aws.securityhub.model.SecurityControlDefinition]
  type SecurityControls = List[zio.aws.securityhub.model.SecurityControl]
  type SecurityGroups = List[NonEmptyString]
  type SensitiveDataDetectionsList =
    List[zio.aws.securityhub.model.SensitiveDataDetections]
  type SensitiveDataResultList =
    List[zio.aws.securityhub.model.SensitiveDataResult]
  type SoftwarePackageList = List[zio.aws.securityhub.model.SoftwarePackage]
  type SortCriteria = List[zio.aws.securityhub.model.SortCriterion]
  type Standards = List[zio.aws.securityhub.model.Standard]
  type StandardsControlArnList = List[NonEmptyString]
  type StandardsControlAssociationDetails =
    List[zio.aws.securityhub.model.StandardsControlAssociationDetail]
  type StandardsControlAssociationIds =
    List[zio.aws.securityhub.model.StandardsControlAssociationId]
  type StandardsControlAssociationSummaries =
    List[zio.aws.securityhub.model.StandardsControlAssociationSummary]
  type StandardsControlAssociationUpdates =
    List[zio.aws.securityhub.model.StandardsControlAssociationUpdate]
  type StandardsControls = List[zio.aws.securityhub.model.StandardsControl]
  type StandardsInputParameterMap = Map[NonEmptyString, NonEmptyString]
  type StandardsSubscriptionArns = List[NonEmptyString]
  type StandardsSubscriptionRequests =
    List[zio.aws.securityhub.model.StandardsSubscriptionRequest]
  type StandardsSubscriptions =
    List[zio.aws.securityhub.model.StandardsSubscription]
  type StatelessCustomPublishMetricActionDimensionsList =
    List[zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension]
  type StatusReasonsList = List[zio.aws.securityhub.model.StatusReason]
  type StringFilterList = List[zio.aws.securityhub.model.StringFilter]
  type StringList = List[NonEmptyString]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type ThreatIntelIndicatorList =
    List[zio.aws.securityhub.model.ThreatIntelIndicator]
  type ThreatList = List[zio.aws.securityhub.model.Threat]
  type TypeList = List[NonEmptyString]
  type UnprocessedAutomationRulesList =
    List[zio.aws.securityhub.model.UnprocessedAutomationRule]
  type UnprocessedSecurityControls =
    List[zio.aws.securityhub.model.UnprocessedSecurityControl]
  type UnprocessedStandardsControlAssociationUpdates =
    List[zio.aws.securityhub.model.UnprocessedStandardsControlAssociationUpdate]
  type UnprocessedStandardsControlAssociations =
    List[zio.aws.securityhub.model.UnprocessedStandardsControlAssociation]
  type UpdateAutomationRulesRequestItemsList =
    List[zio.aws.securityhub.model.UpdateAutomationRulesRequestItem]
  type VolumeMountList = List[zio.aws.securityhub.model.VolumeMount]
  type VpcInfoCidrBlockSetList =
    List[zio.aws.securityhub.model.VpcInfoCidrBlockSetDetails]
  type VpcInfoIpv6CidrBlockSetList =
    List[zio.aws.securityhub.model.VpcInfoIpv6CidrBlockSetDetails]
  type VulnerabilityCodeVulnerabilitiesList =
    List[zio.aws.securityhub.model.VulnerabilityCodeVulnerabilities]
  type VulnerabilityList = List[zio.aws.securityhub.model.Vulnerability]
  type WafExcludedRuleList = List[zio.aws.securityhub.model.WafExcludedRule]
}
