package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Vulnerability(
    id: NonEmptyString,
    vulnerablePackages: Optional[
      Iterable[zio.aws.securityhub.model.SoftwarePackage]
    ] = Optional.Absent,
    cvss: Optional[Iterable[zio.aws.securityhub.model.Cvss]] = Optional.Absent,
    relatedVulnerabilities: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    vendor: Optional[zio.aws.securityhub.model.VulnerabilityVendor] =
      Optional.Absent,
    referenceUrls: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    fixAvailable: Optional[
      zio.aws.securityhub.model.VulnerabilityFixAvailable
    ] = Optional.Absent,
    epssScore: Optional[Double] = Optional.Absent,
    exploitAvailable: Optional[
      zio.aws.securityhub.model.VulnerabilityExploitAvailable
    ] = Optional.Absent,
    codeVulnerabilities: Optional[
      Iterable[zio.aws.securityhub.model.VulnerabilityCodeVulnerabilities]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Vulnerability = {
    import Vulnerability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Vulnerability
      .builder()
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .optionallyWith(
        vulnerablePackages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vulnerablePackages)
      .optionallyWith(
        cvss.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cvss)
      .optionallyWith(
        relatedVulnerabilities.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.relatedVulnerabilities)
      .optionallyWith(vendor.map(value => value.buildAwsValue()))(_.vendor)
      .optionallyWith(
        referenceUrls.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.referenceUrls)
      .optionallyWith(fixAvailable.map(value => value.unwrap))(_.fixAvailable)
      .optionallyWith(epssScore.map(value => value: java.lang.Double))(
        _.epssScore
      )
      .optionallyWith(exploitAvailable.map(value => value.unwrap))(
        _.exploitAvailable
      )
      .optionallyWith(
        codeVulnerabilities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.codeVulnerabilities)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Vulnerability.ReadOnly =
    zio.aws.securityhub.model.Vulnerability.wrap(buildAwsValue())
}
object Vulnerability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Vulnerability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Vulnerability =
      zio.aws.securityhub.model.Vulnerability(
        id,
        vulnerablePackages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cvss.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relatedVulnerabilities.map(value => value),
        vendor.map(value => value.asEditable),
        referenceUrls.map(value => value),
        fixAvailable.map(value => value),
        epssScore.map(value => value),
        exploitAvailable.map(value => value),
        codeVulnerabilities.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: NonEmptyString
    def vulnerablePackages
        : Optional[List[zio.aws.securityhub.model.SoftwarePackage.ReadOnly]]
    def cvss: Optional[List[zio.aws.securityhub.model.Cvss.ReadOnly]]
    def relatedVulnerabilities: Optional[List[NonEmptyString]]
    def vendor: Optional[zio.aws.securityhub.model.VulnerabilityVendor.ReadOnly]
    def referenceUrls: Optional[List[NonEmptyString]]
    def fixAvailable
        : Optional[zio.aws.securityhub.model.VulnerabilityFixAvailable]
    def epssScore: Optional[Double]
    def exploitAvailable
        : Optional[zio.aws.securityhub.model.VulnerabilityExploitAvailable]
    def codeVulnerabilities: Optional[
      List[zio.aws.securityhub.model.VulnerabilityCodeVulnerabilities.ReadOnly]
    ]
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
    def getVulnerablePackages: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.SoftwarePackage.ReadOnly
    ]] = AwsError.unwrapOptionField("vulnerablePackages", vulnerablePackages)
    def getCvss
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Cvss.ReadOnly]] =
      AwsError.unwrapOptionField("cvss", cvss)
    def getRelatedVulnerabilities: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "relatedVulnerabilities",
        relatedVulnerabilities
      )
    def getVendor: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.VulnerabilityVendor.ReadOnly
    ] = AwsError.unwrapOptionField("vendor", vendor)
    def getReferenceUrls: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("referenceUrls", referenceUrls)
    def getFixAvailable: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.VulnerabilityFixAvailable
    ] = AwsError.unwrapOptionField("fixAvailable", fixAvailable)
    def getEpssScore: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("epssScore", epssScore)
    def getExploitAvailable: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.VulnerabilityExploitAvailable
    ] = AwsError.unwrapOptionField("exploitAvailable", exploitAvailable)
    def getCodeVulnerabilities: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.VulnerabilityCodeVulnerabilities.ReadOnly
    ]] = AwsError.unwrapOptionField("codeVulnerabilities", codeVulnerabilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Vulnerability
  ) extends zio.aws.securityhub.model.Vulnerability.ReadOnly {
    override val id: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.id())
    override val vulnerablePackages
        : Optional[List[zio.aws.securityhub.model.SoftwarePackage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vulnerablePackages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.SoftwarePackage.wrap(item)
          }.toList
        )
    override val cvss: Optional[List[zio.aws.securityhub.model.Cvss.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cvss())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Cvss.wrap(item)
          }.toList
        )
    override val relatedVulnerabilities: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedVulnerabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val vendor
        : Optional[zio.aws.securityhub.model.VulnerabilityVendor.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendor())
        .map(value => zio.aws.securityhub.model.VulnerabilityVendor.wrap(value))
    override val referenceUrls: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referenceUrls())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val fixAvailable
        : Optional[zio.aws.securityhub.model.VulnerabilityFixAvailable] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fixAvailable())
        .map(value =>
          zio.aws.securityhub.model.VulnerabilityFixAvailable.wrap(value)
        )
    override val epssScore: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.epssScore())
      .map(value => value: Double)
    override val exploitAvailable
        : Optional[zio.aws.securityhub.model.VulnerabilityExploitAvailable] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exploitAvailable())
        .map(value =>
          zio.aws.securityhub.model.VulnerabilityExploitAvailable.wrap(value)
        )
    override val codeVulnerabilities: Optional[
      List[zio.aws.securityhub.model.VulnerabilityCodeVulnerabilities.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.codeVulnerabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.VulnerabilityCodeVulnerabilities.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Vulnerability
  ): zio.aws.securityhub.model.Vulnerability.ReadOnly = new Wrapper(impl)
}
