package zio.aws.securityhub.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{RuleOrderValue, NonEmptyString}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateAutomationRulesRequestItem(
    ruleArn: NonEmptyString,
    ruleStatus: Optional[zio.aws.securityhub.model.RuleStatus] =
      Optional.Absent,
    ruleOrder: Optional[RuleOrderValue] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    ruleName: Optional[NonEmptyString] = Optional.Absent,
    isTerminal: Optional[Boolean] = Optional.Absent,
    criteria: Optional[
      zio.aws.securityhub.model.AutomationRulesFindingFilters
    ] = Optional.Absent,
    actions: Optional[
      Iterable[zio.aws.securityhub.model.AutomationRulesAction]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.UpdateAutomationRulesRequestItem = {
    import UpdateAutomationRulesRequestItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.UpdateAutomationRulesRequestItem
      .builder()
      .ruleArn(NonEmptyString.unwrap(ruleArn): java.lang.String)
      .optionallyWith(ruleStatus.map(value => value.unwrap))(_.ruleStatus)
      .optionallyWith(
        ruleOrder.map(value => RuleOrderValue.unwrap(value): Integer)
      )(_.ruleOrder)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        ruleName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleName)
      .optionallyWith(isTerminal.map(value => value: java.lang.Boolean))(
        _.isTerminal
      )
      .optionallyWith(criteria.map(value => value.buildAwsValue()))(_.criteria)
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.UpdateAutomationRulesRequestItem.ReadOnly =
    zio.aws.securityhub.model.UpdateAutomationRulesRequestItem
      .wrap(buildAwsValue())
}
object UpdateAutomationRulesRequestItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.UpdateAutomationRulesRequestItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.UpdateAutomationRulesRequestItem =
      zio.aws.securityhub.model.UpdateAutomationRulesRequestItem(
        ruleArn,
        ruleStatus.map(value => value),
        ruleOrder.map(value => value),
        description.map(value => value),
        ruleName.map(value => value),
        isTerminal.map(value => value),
        criteria.map(value => value.asEditable),
        actions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ruleArn: NonEmptyString
    def ruleStatus: Optional[zio.aws.securityhub.model.RuleStatus]
    def ruleOrder: Optional[RuleOrderValue]
    def description: Optional[NonEmptyString]
    def ruleName: Optional[NonEmptyString]
    def isTerminal: Optional[Boolean]
    def criteria: Optional[
      zio.aws.securityhub.model.AutomationRulesFindingFilters.ReadOnly
    ]
    def actions: Optional[
      List[zio.aws.securityhub.model.AutomationRulesAction.ReadOnly]
    ]
    def getRuleArn: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(ruleArn)
    def getRuleStatus
        : ZIO[Any, AwsError, zio.aws.securityhub.model.RuleStatus] =
      AwsError.unwrapOptionField("ruleStatus", ruleStatus)
    def getRuleOrder: ZIO[Any, AwsError, RuleOrderValue] =
      AwsError.unwrapOptionField("ruleOrder", ruleOrder)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getRuleName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getIsTerminal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isTerminal", isTerminal)
    def getCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AutomationRulesFindingFilters.ReadOnly
    ] = AwsError.unwrapOptionField("criteria", criteria)
    def getActions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AutomationRulesAction.ReadOnly
    ]] = AwsError.unwrapOptionField("actions", actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateAutomationRulesRequestItem
  ) extends zio.aws.securityhub.model.UpdateAutomationRulesRequestItem.ReadOnly {
    override val ruleArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.ruleArn())
    override val ruleStatus: Optional[zio.aws.securityhub.model.RuleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleStatus())
        .map(value => zio.aws.securityhub.model.RuleStatus.wrap(value))
    override val ruleOrder: Optional[RuleOrderValue] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleOrder())
      .map(value => zio.aws.securityhub.model.primitives.RuleOrderValue(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ruleName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val isTerminal: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isTerminal())
      .map(value => value: Boolean)
    override val criteria: Optional[
      zio.aws.securityhub.model.AutomationRulesFindingFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.criteria())
      .map(value =>
        zio.aws.securityhub.model.AutomationRulesFindingFilters.wrap(value)
      )
    override val actions: Optional[
      List[zio.aws.securityhub.model.AutomationRulesAction.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.actions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AutomationRulesAction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateAutomationRulesRequestItem
  ): zio.aws.securityhub.model.UpdateAutomationRulesRequestItem.ReadOnly =
    new Wrapper(impl)
}
