package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StandardsSubscription(
    standardsSubscriptionArn: NonEmptyString,
    standardsArn: NonEmptyString,
    standardsInput: Map[NonEmptyString, NonEmptyString],
    standardsStatus: zio.aws.securityhub.model.StandardsStatus,
    standardsStatusReason: Optional[
      zio.aws.securityhub.model.StandardsStatusReason
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StandardsSubscription = {
    import StandardsSubscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StandardsSubscription
      .builder()
      .standardsSubscriptionArn(
        NonEmptyString.unwrap(standardsSubscriptionArn): java.lang.String
      )
      .standardsArn(NonEmptyString.unwrap(standardsArn): java.lang.String)
      .standardsInput(
        standardsInput
          .map({ case (key, value) =>
            (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .standardsStatus(standardsStatus.unwrap)
      .optionallyWith(
        standardsStatusReason.map(value => value.buildAwsValue())
      )(_.standardsStatusReason)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.StandardsSubscription.ReadOnly =
    zio.aws.securityhub.model.StandardsSubscription.wrap(buildAwsValue())
}
object StandardsSubscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StandardsSubscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.StandardsSubscription =
      zio.aws.securityhub.model.StandardsSubscription(
        standardsSubscriptionArn,
        standardsArn,
        standardsInput,
        standardsStatus,
        standardsStatusReason.map(value => value.asEditable)
      )
    def standardsSubscriptionArn: NonEmptyString
    def standardsArn: NonEmptyString
    def standardsInput: Map[NonEmptyString, NonEmptyString]
    def standardsStatus: zio.aws.securityhub.model.StandardsStatus
    def standardsStatusReason
        : Optional[zio.aws.securityhub.model.StandardsStatusReason.ReadOnly]
    def getStandardsSubscriptionArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(standardsSubscriptionArn)
    def getStandardsArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(standardsArn)
    def getStandardsInput
        : ZIO[Any, Nothing, Map[NonEmptyString, NonEmptyString]] =
      ZIO.succeed(standardsInput)
    def getStandardsStatus
        : ZIO[Any, Nothing, zio.aws.securityhub.model.StandardsStatus] =
      ZIO.succeed(standardsStatus)
    def getStandardsStatusReason: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.StandardsStatusReason.ReadOnly
    ] =
      AwsError.unwrapOptionField("standardsStatusReason", standardsStatusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsSubscription
  ) extends zio.aws.securityhub.model.StandardsSubscription.ReadOnly {
    override val standardsSubscriptionArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.standardsSubscriptionArn())
    override val standardsArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.standardsArn())
    override val standardsInput: Map[NonEmptyString, NonEmptyString] = impl
      .standardsInput()
      .asScala
      .map({ case (key, value) =>
        zio.aws.securityhub.model.primitives.NonEmptyString(
          key
        ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
      })
      .toMap
    override val standardsStatus: zio.aws.securityhub.model.StandardsStatus =
      zio.aws.securityhub.model.StandardsStatus.wrap(impl.standardsStatus())
    override val standardsStatusReason
        : Optional[zio.aws.securityhub.model.StandardsStatusReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.standardsStatusReason())
        .map(value =>
          zio.aws.securityhub.model.StandardsStatusReason.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsSubscription
  ): zio.aws.securityhub.model.StandardsSubscription.ReadOnly = new Wrapper(
    impl
  )
}
