package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait RuleStatus {
  def unwrap: software.amazon.awssdk.services.securityhub.model.RuleStatus
}
object RuleStatus {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.RuleStatus
  ): zio.aws.securityhub.model.RuleStatus = value match {
    case software.amazon.awssdk.services.securityhub.model.RuleStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.RuleStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.securityhub.model.RuleStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.securityhub.model.RuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.RuleStatus =
      software.amazon.awssdk.services.securityhub.model.RuleStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.securityhub.model.RuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.RuleStatus =
      software.amazon.awssdk.services.securityhub.model.RuleStatus.ENABLED
  }
  case object DISABLED extends zio.aws.securityhub.model.RuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.RuleStatus =
      software.amazon.awssdk.services.securityhub.model.RuleStatus.DISABLED
  }
}
