package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Range(
    start: Optional[Long] = Optional.Absent,
    end: Optional[Long] = Optional.Absent,
    startColumn: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Range = {
    import Range.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Range
      .builder()
      .optionallyWith(start.map(value => value: java.lang.Long))(_.start)
      .optionallyWith(end.map(value => value: java.lang.Long))(_.end)
      .optionallyWith(startColumn.map(value => value: java.lang.Long))(
        _.startColumn
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Range.ReadOnly =
    zio.aws.securityhub.model.Range.wrap(buildAwsValue())
}
object Range {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.securityhub.model.Range] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Range =
      zio.aws.securityhub.model.Range(
        start.map(value => value),
        end.map(value => value),
        startColumn.map(value => value)
      )
    def start: Optional[Long]
    def end: Optional[Long]
    def startColumn: Optional[Long]
    def getStart: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("start", start)
    def getEnd: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("end", end)
    def getStartColumn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("startColumn", startColumn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Range
  ) extends zio.aws.securityhub.model.Range.ReadOnly {
    override val start: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.start())
      .map(value => value: Long)
    override val end: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.end())
      .map(value => value: Long)
    override val startColumn: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.startColumn())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Range
  ): zio.aws.securityhub.model.Range.ReadOnly = new Wrapper(impl)
}
