package zio.aws.securityhub.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{
  MaxResults,
  NextToken,
  NonEmptyString
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStandardsControlAssociationsRequest(
    securityControlId: NonEmptyString,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest = {
    import ListStandardsControlAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest
      .builder()
      .securityControlId(
        NonEmptyString.unwrap(securityControlId): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.ListStandardsControlAssociationsRequest.ReadOnly =
    zio.aws.securityhub.model.ListStandardsControlAssociationsRequest
      .wrap(buildAwsValue())
}
object ListStandardsControlAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.ListStandardsControlAssociationsRequest =
      zio.aws.securityhub.model.ListStandardsControlAssociationsRequest(
        securityControlId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def securityControlId: NonEmptyString
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getSecurityControlId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(securityControlId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest
  ) extends zio.aws.securityhub.model.ListStandardsControlAssociationsRequest.ReadOnly {
    override val securityControlId: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.securityControlId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.securityhub.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest
  ): zio.aws.securityhub.model.ListStandardsControlAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
