package zio.aws.securityhub.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{
  MaxResults,
  NextToken,
  NonEmptyString
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSecurityControlDefinitionsRequest(
    standardsArn: Optional[NonEmptyString] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest = {
    import ListSecurityControlDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest
      .builder()
      .optionallyWith(
        standardsArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.standardsArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.ListSecurityControlDefinitionsRequest.ReadOnly =
    zio.aws.securityhub.model.ListSecurityControlDefinitionsRequest
      .wrap(buildAwsValue())
}
object ListSecurityControlDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.ListSecurityControlDefinitionsRequest =
      zio.aws.securityhub.model.ListSecurityControlDefinitionsRequest(
        standardsArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def standardsArn: Optional[NonEmptyString]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getStandardsArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("standardsArn", standardsArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest
  ) extends zio.aws.securityhub.model.ListSecurityControlDefinitionsRequest.ReadOnly {
    override val standardsArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.standardsArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.securityhub.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest
  ): zio.aws.securityhub.model.ListSecurityControlDefinitionsRequest.ReadOnly =
    new Wrapper(impl)
}
