package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait IntegrationType {
  def unwrap: software.amazon.awssdk.services.securityhub.model.IntegrationType
}
object IntegrationType {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.IntegrationType
  ): zio.aws.securityhub.model.IntegrationType = value match {
    case software.amazon.awssdk.services.securityhub.model.IntegrationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.IntegrationType.SEND_FINDINGS_TO_SECURITY_HUB =>
      val r = SEND_FINDINGS_TO_SECURITY_HUB
      r
    case software.amazon.awssdk.services.securityhub.model.IntegrationType.RECEIVE_FINDINGS_FROM_SECURITY_HUB =>
      val r = RECEIVE_FINDINGS_FROM_SECURITY_HUB
      r
    case software.amazon.awssdk.services.securityhub.model.IntegrationType.UPDATE_FINDINGS_IN_SECURITY_HUB =>
      val r = UPDATE_FINDINGS_IN_SECURITY_HUB
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.IntegrationType =
      software.amazon.awssdk.services.securityhub.model.IntegrationType.UNKNOWN_TO_SDK_VERSION
  }
  case object SEND_FINDINGS_TO_SECURITY_HUB
      extends zio.aws.securityhub.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.IntegrationType =
      software.amazon.awssdk.services.securityhub.model.IntegrationType.SEND_FINDINGS_TO_SECURITY_HUB
  }
  case object RECEIVE_FINDINGS_FROM_SECURITY_HUB
      extends zio.aws.securityhub.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.IntegrationType =
      software.amazon.awssdk.services.securityhub.model.IntegrationType.RECEIVE_FINDINGS_FROM_SECURITY_HUB
  }
  case object UPDATE_FINDINGS_IN_SECURITY_HUB
      extends zio.aws.securityhub.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.IntegrationType =
      software.amazon.awssdk.services.securityhub.model.IntegrationType.UPDATE_FINDINGS_IN_SECURITY_HUB
  }
}
