package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FindingHistoryUpdateSource(
    `type`: Optional[zio.aws.securityhub.model.FindingHistoryUpdateSourceType] =
      Optional.Absent,
    identity: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSource = {
    import FindingHistoryUpdateSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSource
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        identity.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.identity)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.FindingHistoryUpdateSource.ReadOnly =
    zio.aws.securityhub.model.FindingHistoryUpdateSource.wrap(buildAwsValue())
}
object FindingHistoryUpdateSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.FindingHistoryUpdateSource =
      zio.aws.securityhub.model.FindingHistoryUpdateSource(
        `type`.map(value => value),
        identity.map(value => value)
      )
    def `type`
        : Optional[zio.aws.securityhub.model.FindingHistoryUpdateSourceType]
    def identity: Optional[NonEmptyString]
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.FindingHistoryUpdateSourceType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getIdentity: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("identity", identity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSource
  ) extends zio.aws.securityhub.model.FindingHistoryUpdateSource.ReadOnly {
    override val `type`
        : Optional[zio.aws.securityhub.model.FindingHistoryUpdateSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.securityhub.model.FindingHistoryUpdateSourceType.wrap(value)
        )
    override val identity: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.identity())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSource
  ): zio.aws.securityhub.model.FindingHistoryUpdateSource.ReadOnly =
    new Wrapper(impl)
}
