package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FindingHistoryUpdate(
    updatedField: Optional[NonEmptyString] = Optional.Absent,
    oldValue: Optional[NonEmptyString] = Optional.Absent,
    newValue: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdate = {
    import FindingHistoryUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdate
      .builder()
      .optionallyWith(
        updatedField.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.updatedField)
      .optionallyWith(
        oldValue.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.oldValue)
      .optionallyWith(
        newValue.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.newValue)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.FindingHistoryUpdate.ReadOnly =
    zio.aws.securityhub.model.FindingHistoryUpdate.wrap(buildAwsValue())
}
object FindingHistoryUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.FindingHistoryUpdate =
      zio.aws.securityhub.model.FindingHistoryUpdate(
        updatedField.map(value => value),
        oldValue.map(value => value),
        newValue.map(value => value)
      )
    def updatedField: Optional[NonEmptyString]
    def oldValue: Optional[NonEmptyString]
    def newValue: Optional[NonEmptyString]
    def getUpdatedField: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("updatedField", updatedField)
    def getOldValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("oldValue", oldValue)
    def getNewValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("newValue", newValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdate
  ) extends zio.aws.securityhub.model.FindingHistoryUpdate.ReadOnly {
    override val updatedField: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedField())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val oldValue: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.oldValue())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val newValue: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.newValue())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdate
  ): zio.aws.securityhub.model.FindingHistoryUpdate.ReadOnly = new Wrapper(impl)
}
