package zio.aws.securityhub.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{
  NonEmptyString,
  MaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeProductsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    productArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest = {
    import DescribeProductsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        productArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.productArn)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DescribeProductsRequest.ReadOnly =
    zio.aws.securityhub.model.DescribeProductsRequest.wrap(buildAwsValue())
}
object DescribeProductsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DescribeProductsRequest =
      zio.aws.securityhub.model.DescribeProductsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        productArn.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def productArn: Optional[NonEmptyString]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getProductArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("productArn", productArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest
  ) extends zio.aws.securityhub.model.DescribeProductsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.securityhub.model.primitives.MaxResults(value))
    override val productArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.productArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest
  ): zio.aws.securityhub.model.DescribeProductsRequest.ReadOnly = new Wrapper(
    impl
  )
}
