package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeHubRequest(
    hubArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DescribeHubRequest = {
    import DescribeHubRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DescribeHubRequest
      .builder()
      .optionallyWith(
        hubArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.hubArn)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DescribeHubRequest.ReadOnly =
    zio.aws.securityhub.model.DescribeHubRequest.wrap(buildAwsValue())
}
object DescribeHubRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DescribeHubRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DescribeHubRequest =
      zio.aws.securityhub.model.DescribeHubRequest(hubArn.map(value => value))
    def hubArn: Optional[NonEmptyString]
    def getHubArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hubArn", hubArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeHubRequest
  ) extends zio.aws.securityhub.model.DescribeHubRequest.ReadOnly {
    override val hubArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.hubArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeHubRequest
  ): zio.aws.securityhub.model.DescribeHubRequest.ReadOnly = new Wrapper(impl)
}
