package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait DateRangeUnit {
  def unwrap: software.amazon.awssdk.services.securityhub.model.DateRangeUnit
}
object DateRangeUnit {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.DateRangeUnit
  ): zio.aws.securityhub.model.DateRangeUnit = value match {
    case software.amazon.awssdk.services.securityhub.model.DateRangeUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.DateRangeUnit.DAYS =>
      val r = DAYS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.DateRangeUnit {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.DateRangeUnit =
      software.amazon.awssdk.services.securityhub.model.DateRangeUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object DAYS extends zio.aws.securityhub.model.DateRangeUnit {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.DateRangeUnit =
      software.amazon.awssdk.services.securityhub.model.DateRangeUnit.DAYS
  }
}
