package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAutomationRuleResponse(
    ruleArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleResponse = {
    import CreateAutomationRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleResponse
      .builder()
      .optionallyWith(
        ruleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.CreateAutomationRuleResponse.ReadOnly =
    zio.aws.securityhub.model.CreateAutomationRuleResponse.wrap(buildAwsValue())
}
object CreateAutomationRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CreateAutomationRuleResponse =
      zio.aws.securityhub.model
        .CreateAutomationRuleResponse(ruleArn.map(value => value))
    def ruleArn: Optional[NonEmptyString]
    def getRuleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleArn", ruleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleResponse
  ) extends zio.aws.securityhub.model.CreateAutomationRuleResponse.ReadOnly {
    override val ruleArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleResponse
  ): zio.aws.securityhub.model.CreateAutomationRuleResponse.ReadOnly =
    new Wrapper(impl)
}
