package zio.aws.securityhub.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{
  NonEmptyString,
  RuleOrderValue,
  TagValue,
  TagKey
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateAutomationRuleRequest(
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    ruleStatus: Optional[zio.aws.securityhub.model.RuleStatus] =
      Optional.Absent,
    ruleOrder: RuleOrderValue,
    ruleName: NonEmptyString,
    description: NonEmptyString,
    isTerminal: Optional[Boolean] = Optional.Absent,
    criteria: zio.aws.securityhub.model.AutomationRulesFindingFilters,
    actions: Iterable[zio.aws.securityhub.model.AutomationRulesAction]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleRequest = {
    import CreateAutomationRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleRequest
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(ruleStatus.map(value => value.unwrap))(_.ruleStatus)
      .ruleOrder(RuleOrderValue.unwrap(ruleOrder): Integer)
      .ruleName(NonEmptyString.unwrap(ruleName): java.lang.String)
      .description(NonEmptyString.unwrap(description): java.lang.String)
      .optionallyWith(isTerminal.map(value => value: java.lang.Boolean))(
        _.isTerminal
      )
      .criteria(criteria.buildAwsValue())
      .actions(actions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.CreateAutomationRuleRequest.ReadOnly =
    zio.aws.securityhub.model.CreateAutomationRuleRequest.wrap(buildAwsValue())
}
object CreateAutomationRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CreateAutomationRuleRequest =
      zio.aws.securityhub.model.CreateAutomationRuleRequest(
        tags.map(value => value),
        ruleStatus.map(value => value),
        ruleOrder,
        ruleName,
        description,
        isTerminal.map(value => value),
        criteria.asEditable,
        actions.map { item =>
          item.asEditable
        }
      )
    def tags: Optional[Map[TagKey, TagValue]]
    def ruleStatus: Optional[zio.aws.securityhub.model.RuleStatus]
    def ruleOrder: RuleOrderValue
    def ruleName: NonEmptyString
    def description: NonEmptyString
    def isTerminal: Optional[Boolean]
    def criteria
        : zio.aws.securityhub.model.AutomationRulesFindingFilters.ReadOnly
    def actions: List[zio.aws.securityhub.model.AutomationRulesAction.ReadOnly]
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRuleStatus
        : ZIO[Any, AwsError, zio.aws.securityhub.model.RuleStatus] =
      AwsError.unwrapOptionField("ruleStatus", ruleStatus)
    def getRuleOrder: ZIO[Any, Nothing, RuleOrderValue] = ZIO.succeed(ruleOrder)
    def getRuleName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(ruleName)
    def getDescription: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(description)
    def getIsTerminal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isTerminal", isTerminal)
    def getCriteria: ZIO[
      Any,
      Nothing,
      zio.aws.securityhub.model.AutomationRulesFindingFilters.ReadOnly
    ] = ZIO.succeed(criteria)
    def getActions: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.AutomationRulesAction.ReadOnly
    ]] = ZIO.succeed(actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleRequest
  ) extends zio.aws.securityhub.model.CreateAutomationRuleRequest.ReadOnly {
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.TagKey(
              key
            ) -> zio.aws.securityhub.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val ruleStatus: Optional[zio.aws.securityhub.model.RuleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleStatus())
        .map(value => zio.aws.securityhub.model.RuleStatus.wrap(value))
    override val ruleOrder: RuleOrderValue =
      zio.aws.securityhub.model.primitives.RuleOrderValue(impl.ruleOrder())
    override val ruleName: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.ruleName())
    override val description: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.description())
    override val isTerminal: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isTerminal())
      .map(value => value: Boolean)
    override val criteria
        : zio.aws.securityhub.model.AutomationRulesFindingFilters.ReadOnly =
      zio.aws.securityhub.model.AutomationRulesFindingFilters
        .wrap(impl.criteria())
    override val actions
        : List[zio.aws.securityhub.model.AutomationRulesAction.ReadOnly] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.AutomationRulesAction.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleRequest
  ): zio.aws.securityhub.model.CreateAutomationRuleRequest.ReadOnly =
    new Wrapper(impl)
}
