package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait ControlFindingGenerator {
  def unwrap: software.amazon.awssdk.services.securityhub.model.ControlFindingGenerator
}
object ControlFindingGenerator {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.ControlFindingGenerator
  ): zio.aws.securityhub.model.ControlFindingGenerator = value match {
    case software.amazon.awssdk.services.securityhub.model.ControlFindingGenerator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.ControlFindingGenerator.STANDARD_CONTROL =>
      val r = STANDARD_CONTROL
      r
    case software.amazon.awssdk.services.securityhub.model.ControlFindingGenerator.SECURITY_CONTROL =>
      val r = SECURITY_CONTROL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.ControlFindingGenerator {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ControlFindingGenerator =
      software.amazon.awssdk.services.securityhub.model.ControlFindingGenerator.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD_CONTROL
      extends zio.aws.securityhub.model.ControlFindingGenerator {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ControlFindingGenerator =
      software.amazon.awssdk.services.securityhub.model.ControlFindingGenerator.STANDARD_CONTROL
  }
  case object SECURITY_CONTROL
      extends zio.aws.securityhub.model.ControlFindingGenerator {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ControlFindingGenerator =
      software.amazon.awssdk.services.securityhub.model.ControlFindingGenerator.SECURITY_CONTROL
  }
}
