package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BooleanFilter(value: Optional[Boolean] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BooleanFilter = {
    import BooleanFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BooleanFilter
      .builder()
      .optionallyWith(value.map(value => value: java.lang.Boolean))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.BooleanFilter.ReadOnly =
    zio.aws.securityhub.model.BooleanFilter.wrap(buildAwsValue())
}
object BooleanFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BooleanFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.BooleanFilter =
      zio.aws.securityhub.model.BooleanFilter(value.map(value => value))
    def value: Optional[Boolean]
    def getValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BooleanFilter
  ) extends zio.aws.securityhub.model.BooleanFilter.ReadOnly {
    override val value: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BooleanFilter
  ): zio.aws.securityhub.model.BooleanFilter.ReadOnly = new Wrapper(impl)
}
