package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetSecurityControlsResponse(
    securityControls: Iterable[zio.aws.securityhub.model.SecurityControl],
    unprocessedIds: Optional[
      Iterable[zio.aws.securityhub.model.UnprocessedSecurityControl]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchGetSecurityControlsResponse = {
    import BatchGetSecurityControlsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchGetSecurityControlsResponse
      .builder()
      .securityControls(securityControls.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        unprocessedIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedIds)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchGetSecurityControlsResponse.ReadOnly =
    zio.aws.securityhub.model.BatchGetSecurityControlsResponse
      .wrap(buildAwsValue())
}
object BatchGetSecurityControlsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchGetSecurityControlsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.BatchGetSecurityControlsResponse =
      zio.aws.securityhub.model.BatchGetSecurityControlsResponse(
        securityControls.map { item =>
          item.asEditable
        },
        unprocessedIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def securityControls
        : List[zio.aws.securityhub.model.SecurityControl.ReadOnly]
    def unprocessedIds: Optional[
      List[zio.aws.securityhub.model.UnprocessedSecurityControl.ReadOnly]
    ]
    def getSecurityControls: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.SecurityControl.ReadOnly
    ]] = ZIO.succeed(securityControls)
    def getUnprocessedIds: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.UnprocessedSecurityControl.ReadOnly
    ]] = AwsError.unwrapOptionField("unprocessedIds", unprocessedIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchGetSecurityControlsResponse
  ) extends zio.aws.securityhub.model.BatchGetSecurityControlsResponse.ReadOnly {
    override val securityControls
        : List[zio.aws.securityhub.model.SecurityControl.ReadOnly] = impl
      .securityControls()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.SecurityControl.wrap(item)
      }
      .toList
    override val unprocessedIds: Optional[
      List[zio.aws.securityhub.model.UnprocessedSecurityControl.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.unprocessedIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.UnprocessedSecurityControl.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchGetSecurityControlsResponse
  ): zio.aws.securityhub.model.BatchGetSecurityControlsResponse.ReadOnly =
    new Wrapper(impl)
}
