package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetAutomationRulesResponse(
    rules: Optional[Iterable[zio.aws.securityhub.model.AutomationRulesConfig]] =
      Optional.Absent,
    unprocessedAutomationRules: Optional[
      Iterable[zio.aws.securityhub.model.UnprocessedAutomationRule]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchGetAutomationRulesResponse = {
    import BatchGetAutomationRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchGetAutomationRulesResponse
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(
        unprocessedAutomationRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAutomationRules)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchGetAutomationRulesResponse.ReadOnly =
    zio.aws.securityhub.model.BatchGetAutomationRulesResponse
      .wrap(buildAwsValue())
}
object BatchGetAutomationRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchGetAutomationRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.BatchGetAutomationRulesResponse =
      zio.aws.securityhub.model.BatchGetAutomationRulesResponse(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedAutomationRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def rules: Optional[
      List[zio.aws.securityhub.model.AutomationRulesConfig.ReadOnly]
    ]
    def unprocessedAutomationRules: Optional[
      List[zio.aws.securityhub.model.UnprocessedAutomationRule.ReadOnly]
    ]
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AutomationRulesConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
    def getUnprocessedAutomationRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.UnprocessedAutomationRule.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedAutomationRules",
      unprocessedAutomationRules
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchGetAutomationRulesResponse
  ) extends zio.aws.securityhub.model.BatchGetAutomationRulesResponse.ReadOnly {
    override val rules: Optional[
      List[zio.aws.securityhub.model.AutomationRulesConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AutomationRulesConfig.wrap(item)
        }.toList
      )
    override val unprocessedAutomationRules: Optional[
      List[zio.aws.securityhub.model.UnprocessedAutomationRule.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.unprocessedAutomationRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.UnprocessedAutomationRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchGetAutomationRulesResponse
  ): zio.aws.securityhub.model.BatchGetAutomationRulesResponse.ReadOnly =
    new Wrapper(impl)
}
