package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetAutomationRulesRequest(
    automationRulesArns: Iterable[NonEmptyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchGetAutomationRulesRequest = {
    import BatchGetAutomationRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchGetAutomationRulesRequest
      .builder()
      .automationRulesArns(automationRulesArns.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchGetAutomationRulesRequest.ReadOnly =
    zio.aws.securityhub.model.BatchGetAutomationRulesRequest
      .wrap(buildAwsValue())
}
object BatchGetAutomationRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchGetAutomationRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.BatchGetAutomationRulesRequest =
      zio.aws.securityhub.model
        .BatchGetAutomationRulesRequest(automationRulesArns)
    def automationRulesArns: List[NonEmptyString]
    def getAutomationRulesArns: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(automationRulesArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchGetAutomationRulesRequest
  ) extends zio.aws.securityhub.model.BatchGetAutomationRulesRequest.ReadOnly {
    override val automationRulesArns: List[NonEmptyString] = impl
      .automationRulesArns()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchGetAutomationRulesRequest
  ): zio.aws.securityhub.model.BatchGetAutomationRulesRequest.ReadOnly =
    new Wrapper(impl)
}
