package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchEnableStandardsResponse(
    standardsSubscriptions: Optional[
      Iterable[zio.aws.securityhub.model.StandardsSubscription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsResponse = {
    import BatchEnableStandardsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsResponse
      .builder()
      .optionallyWith(
        standardsSubscriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.standardsSubscriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchEnableStandardsResponse.ReadOnly =
    zio.aws.securityhub.model.BatchEnableStandardsResponse.wrap(buildAwsValue())
}
object BatchEnableStandardsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.BatchEnableStandardsResponse =
      zio.aws.securityhub.model.BatchEnableStandardsResponse(
        standardsSubscriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def standardsSubscriptions: Optional[
      List[zio.aws.securityhub.model.StandardsSubscription.ReadOnly]
    ]
    def getStandardsSubscriptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StandardsSubscription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "standardsSubscriptions",
      standardsSubscriptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsResponse
  ) extends zio.aws.securityhub.model.BatchEnableStandardsResponse.ReadOnly {
    override val standardsSubscriptions: Optional[
      List[zio.aws.securityhub.model.StandardsSubscription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.standardsSubscriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StandardsSubscription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsResponse
  ): zio.aws.securityhub.model.BatchEnableStandardsResponse.ReadOnly =
    new Wrapper(impl)
}
