package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafRegionalWebAclRulesListActionDetails(
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclRulesListActionDetails = {
    import AwsWafRegionalWebAclRulesListActionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclRulesListActionDetails
      .builder()
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListActionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListActionDetails
      .wrap(buildAwsValue())
}
object AwsWafRegionalWebAclRulesListActionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclRulesListActionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListActionDetails =
      zio.aws.securityhub.model
        .AwsWafRegionalWebAclRulesListActionDetails(`type`.map(value => value))
    def `type`: Optional[NonEmptyString]
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclRulesListActionDetails
  ) extends zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListActionDetails.ReadOnly {
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclRulesListActionDetails
  ): zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListActionDetails.ReadOnly =
    new Wrapper(impl)
}
