package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafRegionalRuleGroupRulesDetails(
    action: Optional[
      zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails
    ] = Optional.Absent,
    priority: Optional[Integer] = Optional.Absent,
    ruleId: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupRulesDetails = {
    import AwsWafRegionalRuleGroupRulesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupRulesDetails
      .builder()
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(priority.map(value => value: java.lang.Integer))(
        _.priority
      )
      .optionallyWith(
        ruleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleId)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesDetails
      .wrap(buildAwsValue())
}
object AwsWafRegionalRuleGroupRulesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupRulesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesDetails =
      zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesDetails(
        action.map(value => value.asEditable),
        priority.map(value => value),
        ruleId.map(value => value),
        `type`.map(value => value)
      )
    def action: Optional[
      zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails.ReadOnly
    ]
    def priority: Optional[Integer]
    def ruleId: Optional[NonEmptyString]
    def `type`: Optional[NonEmptyString]
    def getAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails.ReadOnly
    ] = AwsError.unwrapOptionField("action", action)
    def getPriority: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("priority", priority)
    def getRuleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleId", ruleId)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupRulesDetails
  ) extends zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesDetails.ReadOnly {
    override val action: Optional[
      zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value =>
        zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails
          .wrap(value)
      )
    override val priority: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => value: Integer)
    override val ruleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupRulesDetails
  ): zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesDetails.ReadOnly =
    new Wrapper(impl)
}
