package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails(
    cloudWatchLogsLogGroup: Optional[
      zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails = {
    import AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails
      .builder()
      .optionallyWith(
        cloudWatchLogsLogGroup.map(value => value.buildAwsValue())
      )(_.cloudWatchLogsLogGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails
      .wrap(buildAwsValue())
}
object AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails =
      zio.aws.securityhub.model
        .AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails(
          cloudWatchLogsLogGroup.map(value => value.asEditable)
        )
    def cloudWatchLogsLogGroup: Optional[
      zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails.ReadOnly
    ]
    def getCloudWatchLogsLogGroup: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLogsLogGroup",
      cloudWatchLogsLogGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails
  ) extends zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails.ReadOnly {
    override val cloudWatchLogsLogGroup: Optional[
      zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogsLogGroup())
      .map(value =>
        zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails
  ): zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails.ReadOnly =
    new Wrapper(impl)
}
