package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsSageMakerNotebookInstanceDetails(
    acceleratorTypes: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    additionalCodeRepositories: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    defaultCodeRepository: Optional[NonEmptyString] = Optional.Absent,
    directInternetAccess: Optional[NonEmptyString] = Optional.Absent,
    failureReason: Optional[NonEmptyString] = Optional.Absent,
    instanceMetadataServiceConfiguration: Optional[
      zio.aws.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails
    ] = Optional.Absent,
    instanceType: Optional[NonEmptyString] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    networkInterfaceId: Optional[NonEmptyString] = Optional.Absent,
    notebookInstanceArn: Optional[NonEmptyString] = Optional.Absent,
    notebookInstanceLifecycleConfigName: Optional[NonEmptyString] =
      Optional.Absent,
    notebookInstanceName: Optional[NonEmptyString] = Optional.Absent,
    notebookInstanceStatus: Optional[NonEmptyString] = Optional.Absent,
    platformIdentifier: Optional[NonEmptyString] = Optional.Absent,
    roleArn: Optional[NonEmptyString] = Optional.Absent,
    rootAccess: Optional[NonEmptyString] = Optional.Absent,
    securityGroups: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    subnetId: Optional[NonEmptyString] = Optional.Absent,
    url: Optional[NonEmptyString] = Optional.Absent,
    volumeSizeInGB: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSageMakerNotebookInstanceDetails = {
    import AwsSageMakerNotebookInstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSageMakerNotebookInstanceDetails
      .builder()
      .optionallyWith(
        acceleratorTypes.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.acceleratorTypes)
      .optionallyWith(
        additionalCodeRepositories.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalCodeRepositories)
      .optionallyWith(
        defaultCodeRepository.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.defaultCodeRepository)
      .optionallyWith(
        directInternetAccess.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.directInternetAccess)
      .optionallyWith(
        failureReason.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        instanceMetadataServiceConfiguration.map(value => value.buildAwsValue())
      )(_.instanceMetadataServiceConfiguration)
      .optionallyWith(
        instanceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceType)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        notebookInstanceArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceArn)
      .optionallyWith(
        notebookInstanceLifecycleConfigName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceLifecycleConfigName)
      .optionallyWith(
        notebookInstanceName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceName)
      .optionallyWith(
        notebookInstanceStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceStatus)
      .optionallyWith(
        platformIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.platformIdentifier)
      .optionallyWith(
        roleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        rootAccess.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.rootAccess)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        url.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(volumeSizeInGB.map(value => value: java.lang.Integer))(
        _.volumeSizeInGB
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsSageMakerNotebookInstanceDetails.ReadOnly =
    zio.aws.securityhub.model.AwsSageMakerNotebookInstanceDetails
      .wrap(buildAwsValue())
}
object AwsSageMakerNotebookInstanceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSageMakerNotebookInstanceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsSageMakerNotebookInstanceDetails =
      zio.aws.securityhub.model.AwsSageMakerNotebookInstanceDetails(
        acceleratorTypes.map(value => value),
        additionalCodeRepositories.map(value => value),
        defaultCodeRepository.map(value => value),
        directInternetAccess.map(value => value),
        failureReason.map(value => value),
        instanceMetadataServiceConfiguration.map(value => value.asEditable),
        instanceType.map(value => value),
        kmsKeyId.map(value => value),
        networkInterfaceId.map(value => value),
        notebookInstanceArn.map(value => value),
        notebookInstanceLifecycleConfigName.map(value => value),
        notebookInstanceName.map(value => value),
        notebookInstanceStatus.map(value => value),
        platformIdentifier.map(value => value),
        roleArn.map(value => value),
        rootAccess.map(value => value),
        securityGroups.map(value => value),
        subnetId.map(value => value),
        url.map(value => value),
        volumeSizeInGB.map(value => value)
      )
    def acceleratorTypes: Optional[List[NonEmptyString]]
    def additionalCodeRepositories: Optional[List[NonEmptyString]]
    def defaultCodeRepository: Optional[NonEmptyString]
    def directInternetAccess: Optional[NonEmptyString]
    def failureReason: Optional[NonEmptyString]
    def instanceMetadataServiceConfiguration: Optional[
      zio.aws.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.ReadOnly
    ]
    def instanceType: Optional[NonEmptyString]
    def kmsKeyId: Optional[NonEmptyString]
    def networkInterfaceId: Optional[NonEmptyString]
    def notebookInstanceArn: Optional[NonEmptyString]
    def notebookInstanceLifecycleConfigName: Optional[NonEmptyString]
    def notebookInstanceName: Optional[NonEmptyString]
    def notebookInstanceStatus: Optional[NonEmptyString]
    def platformIdentifier: Optional[NonEmptyString]
    def roleArn: Optional[NonEmptyString]
    def rootAccess: Optional[NonEmptyString]
    def securityGroups: Optional[List[NonEmptyString]]
    def subnetId: Optional[NonEmptyString]
    def url: Optional[NonEmptyString]
    def volumeSizeInGB: Optional[Integer]
    def getAcceleratorTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("acceleratorTypes", acceleratorTypes)
    def getAdditionalCodeRepositories
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "additionalCodeRepositories",
      additionalCodeRepositories
    )
    def getDefaultCodeRepository: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("defaultCodeRepository", defaultCodeRepository)
    def getDirectInternetAccess: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("directInternetAccess", directInternetAccess)
    def getFailureReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getInstanceMetadataServiceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceMetadataServiceConfiguration",
      instanceMetadataServiceConfiguration
    )
    def getInstanceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getNotebookInstanceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("notebookInstanceArn", notebookInstanceArn)
    def getNotebookInstanceLifecycleConfigName
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "notebookInstanceLifecycleConfigName",
      notebookInstanceLifecycleConfigName
    )
    def getNotebookInstanceName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("notebookInstanceName", notebookInstanceName)
    def getNotebookInstanceStatus: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("notebookInstanceStatus", notebookInstanceStatus)
    def getPlatformIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("platformIdentifier", platformIdentifier)
    def getRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getRootAccess: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("rootAccess", rootAccess)
    def getSecurityGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("url", url)
    def getVolumeSizeInGB: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumeSizeInGB", volumeSizeInGB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSageMakerNotebookInstanceDetails
  ) extends zio.aws.securityhub.model.AwsSageMakerNotebookInstanceDetails.ReadOnly {
    override val acceleratorTypes: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val additionalCodeRepositories: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalCodeRepositories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val defaultCodeRepository: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultCodeRepository())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val directInternetAccess: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directInternetAccess())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val failureReason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceMetadataServiceConfiguration: Optional[
      zio.aws.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceMetadataServiceConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails
          .wrap(value)
      )
    override val instanceType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val networkInterfaceId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val notebookInstanceArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookInstanceArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val notebookInstanceLifecycleConfigName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookInstanceLifecycleConfigName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val notebookInstanceName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookInstanceName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val notebookInstanceStatus: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookInstanceStatus())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val platformIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val roleArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rootAccess: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.rootAccess())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val securityGroups: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val subnetId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val url: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val volumeSizeInGB: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSizeInGB())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSageMakerNotebookInstanceDetails
  ): zio.aws.securityhub.model.AwsSageMakerNotebookInstanceDetails.ReadOnly =
    new Wrapper(impl)
}
