package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRoute53QueryLoggingConfigDetails(
    cloudWatchLogsLogGroupArn: Optional[
      zio.aws.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRoute53QueryLoggingConfigDetails = {
    import AwsRoute53QueryLoggingConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRoute53QueryLoggingConfigDetails
      .builder()
      .optionallyWith(
        cloudWatchLogsLogGroupArn.map(value => value.buildAwsValue())
      )(_.cloudWatchLogsLogGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRoute53QueryLoggingConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRoute53QueryLoggingConfigDetails
      .wrap(buildAwsValue())
}
object AwsRoute53QueryLoggingConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRoute53QueryLoggingConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRoute53QueryLoggingConfigDetails =
      zio.aws.securityhub.model.AwsRoute53QueryLoggingConfigDetails(
        cloudWatchLogsLogGroupArn.map(value => value.asEditable)
      )
    def cloudWatchLogsLogGroupArn: Optional[
      zio.aws.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails.ReadOnly
    ]
    def getCloudWatchLogsLogGroupArn: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLogsLogGroupArn",
      cloudWatchLogsLogGroupArn
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRoute53QueryLoggingConfigDetails
  ) extends zio.aws.securityhub.model.AwsRoute53QueryLoggingConfigDetails.ReadOnly {
    override val cloudWatchLogsLogGroupArn: Optional[
      zio.aws.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogsLogGroupArn())
      .map(value =>
        zio.aws.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRoute53QueryLoggingConfigDetails
  ): zio.aws.securityhub.model.AwsRoute53QueryLoggingConfigDetails.ReadOnly =
    new Wrapper(impl)
}
