package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRoute53HostedZoneVpcDetails(
    id: Optional[NonEmptyString] = Optional.Absent,
    region: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneVpcDetails = {
    import AwsRoute53HostedZoneVpcDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneVpcDetails
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        region.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRoute53HostedZoneVpcDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRoute53HostedZoneVpcDetails
      .wrap(buildAwsValue())
}
object AwsRoute53HostedZoneVpcDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneVpcDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRoute53HostedZoneVpcDetails =
      zio.aws.securityhub.model.AwsRoute53HostedZoneVpcDetails(
        id.map(value => value),
        region.map(value => value)
      )
    def id: Optional[NonEmptyString]
    def region: Optional[NonEmptyString]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneVpcDetails
  ) extends zio.aws.securityhub.model.AwsRoute53HostedZoneVpcDetails.ReadOnly {
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val region: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneVpcDetails
  ): zio.aws.securityhub.model.AwsRoute53HostedZoneVpcDetails.ReadOnly =
    new Wrapper(impl)
}
