package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRoute53HostedZoneDetails(
    hostedZone: Optional[
      zio.aws.securityhub.model.AwsRoute53HostedZoneObjectDetails
    ] = Optional.Absent,
    vpcs: Optional[
      Iterable[zio.aws.securityhub.model.AwsRoute53HostedZoneVpcDetails]
    ] = Optional.Absent,
    nameServers: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    queryLoggingConfig: Optional[
      zio.aws.securityhub.model.AwsRoute53QueryLoggingConfigDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneDetails = {
    import AwsRoute53HostedZoneDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneDetails
      .builder()
      .optionallyWith(hostedZone.map(value => value.buildAwsValue()))(
        _.hostedZone
      )
      .optionallyWith(
        vpcs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcs)
      .optionallyWith(
        nameServers.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.nameServers)
      .optionallyWith(queryLoggingConfig.map(value => value.buildAwsValue()))(
        _.queryLoggingConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRoute53HostedZoneDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRoute53HostedZoneDetails.wrap(buildAwsValue())
}
object AwsRoute53HostedZoneDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRoute53HostedZoneDetails =
      zio.aws.securityhub.model.AwsRoute53HostedZoneDetails(
        hostedZone.map(value => value.asEditable),
        vpcs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nameServers.map(value => value),
        queryLoggingConfig.map(value => value.asEditable)
      )
    def hostedZone: Optional[
      zio.aws.securityhub.model.AwsRoute53HostedZoneObjectDetails.ReadOnly
    ]
    def vpcs: Optional[
      List[zio.aws.securityhub.model.AwsRoute53HostedZoneVpcDetails.ReadOnly]
    ]
    def nameServers: Optional[List[NonEmptyString]]
    def queryLoggingConfig: Optional[
      zio.aws.securityhub.model.AwsRoute53QueryLoggingConfigDetails.ReadOnly
    ]
    def getHostedZone: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRoute53HostedZoneObjectDetails.ReadOnly
    ] = AwsError.unwrapOptionField("hostedZone", hostedZone)
    def getVpcs: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRoute53HostedZoneVpcDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcs", vpcs)
    def getNameServers: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("nameServers", nameServers)
    def getQueryLoggingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRoute53QueryLoggingConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("queryLoggingConfig", queryLoggingConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneDetails
  ) extends zio.aws.securityhub.model.AwsRoute53HostedZoneDetails.ReadOnly {
    override val hostedZone: Optional[
      zio.aws.securityhub.model.AwsRoute53HostedZoneObjectDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hostedZone())
      .map(value =>
        zio.aws.securityhub.model.AwsRoute53HostedZoneObjectDetails.wrap(value)
      )
    override val vpcs: Optional[
      List[zio.aws.securityhub.model.AwsRoute53HostedZoneVpcDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRoute53HostedZoneVpcDetails.wrap(item)
        }.toList
      )
    override val nameServers: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameServers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val queryLoggingConfig: Optional[
      zio.aws.securityhub.model.AwsRoute53QueryLoggingConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.queryLoggingConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsRoute53QueryLoggingConfigDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneDetails
  ): zio.aws.securityhub.model.AwsRoute53HostedZoneDetails.ReadOnly =
    new Wrapper(impl)
}
