package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRoute53HostedZoneConfigDetails(
    comment: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneConfigDetails = {
    import AwsRoute53HostedZoneConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneConfigDetails
      .builder()
      .optionallyWith(
        comment.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.comment)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRoute53HostedZoneConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRoute53HostedZoneConfigDetails
      .wrap(buildAwsValue())
}
object AwsRoute53HostedZoneConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRoute53HostedZoneConfigDetails =
      zio.aws.securityhub.model
        .AwsRoute53HostedZoneConfigDetails(comment.map(value => value))
    def comment: Optional[NonEmptyString]
    def getComment: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneConfigDetails
  ) extends zio.aws.securityhub.model.AwsRoute53HostedZoneConfigDetails.ReadOnly {
    override val comment: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneConfigDetails
  ): zio.aws.securityhub.model.AwsRoute53HostedZoneConfigDetails.ReadOnly =
    new Wrapper(impl)
}
